/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.json;

import java.awt.Color;
import net.thucydides.core.model.FeatureResults;
import net.thucydides.core.model.StoryTestResults;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.reports.json.ColorScheme;

public class ProgressColorScheme
implements ColorScheme {
    public static final Color PALE_BLUE = new Color(230, 240, 255);
    public static final Color DONE_BLUE = new Color(0, 35, 255);
    private static final float FIXED_HUE = 0.6f;
    private static final float FIXED_BRIGHTNESS = 1.0f;
    private static final float MINIMUM_SATURATION = 0.1f;
    private static final float MEDIUM_SATURATION = 0.6f;
    private static final float MAXIMUM_SATURATION = 1.0f;

    public Color colorFor(FeatureResults feature) {
        return this.colorForResults(feature.getTotalSteps(), feature.countStepsInSuccessfulTests());
    }

    public Color colorFor(StoryTestResults storyResult) {
        return this.colorForResults(storyResult.getStepCount(), storyResult.countStepsInSuccessfulTests());
    }

    private Color colorForResults(int totalTestSteps, int totalStepsInPassingTests) {
        if (totalStepsInPassingTests == totalTestSteps) {
            return DONE_BLUE;
        }
        return this.calculateColorFromTestCount(totalTestSteps, totalStepsInPassingTests);
    }

    private Color calculateColorFromTestCount(int totalTestSteps, int totalStepsInPassingTests) {
        float saturation = this.calculateValueBetween(0.1f, 1.0f, 0.6f, totalStepsInPassingTests, totalTestSteps - totalStepsInPassingTests);
        return new Color(Color.HSBtoRGB(0.6f, saturation, 1.0f));
    }

    public Color colorFor(TestOutcome outcome) {
        switch (outcome.getResult()) {
            case SUCCESS: {
                return DONE_BLUE;
            }
        }
        return PALE_BLUE;
    }

    public Color colorFor(TestStep step) {
        switch (step.getResult()) {
            case SUCCESS: {
                return DONE_BLUE;
            }
        }
        return PALE_BLUE;
    }

    private float calculateValueBetween(float startColor, float endColor, float zeroColor, int mainCount, int complementaryCount) {
        if (mainCount + complementaryCount == 0) {
            return zeroColor;
        }
        float totalCount = mainCount + complementaryCount;
        float deltaColor = endColor - startColor;
        return startColor + (float)mainCount / totalCount * deltaColor;
    }
}

