/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.lang.reflect.Method;
import net.thucydides.core.util.NameConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutedStepDescription
implements Cloneable {
    private final Class<? extends Object> stepsClass;
    private final String name;
    private boolean isAGroup;

    protected ExecutedStepDescription(Class<? extends Object> stepsClass, String name) {
        this.stepsClass = stepsClass;
        this.name = name;
    }

    protected ExecutedStepDescription(Class<? extends Object> stepsClass, String name, boolean isAGroup) {
        this.stepsClass = stepsClass;
        this.name = name;
        this.isAGroup = isAGroup;
    }

    protected ExecutedStepDescription(String name) {
        this.stepsClass = null;
        this.name = name;
    }

    public ExecutedStepDescription clone() {
        return new ExecutedStepDescription(this.stepsClass, this.name, this.isAGroup);
    }

    public Class<? extends Object> getStepClass() {
        return this.stepsClass;
    }

    public String getName() {
        return this.name;
    }

    public static ExecutedStepDescription of(Class<? extends Object> stepsClass, String name) {
        return new ExecutedStepDescription(stepsClass, name);
    }

    public static ExecutedStepDescription withTitle(String name) {
        return new ExecutedStepDescription(name);
    }

    public boolean isAGroup() {
        return this.isAGroup;
    }

    public void setAGroup(boolean aGroup) {
        this.isAGroup = aGroup;
    }

    public Method getTestMethod() {
        if (this.getStepClass() != null) {
            return this.methodCalled(NameConverter.withNoArguments(this.getName()), this.getStepClass());
        }
        return null;
    }

    private Method methodCalled(String methodName, Class<?> testClass) {
        Method[] methods;
        for (Method method : methods = testClass.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        throw new IllegalArgumentException("No test method called " + methodName + " was found in " + testClass);
    }

    public String getTitle() {
        return NameConverter.humanize(this.name);
    }
}

