/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations;

import java.lang.reflect.Method;
import net.thucydides.core.annotations.Pending;
import net.thucydides.core.annotations.Title;
import net.thucydides.core.util.NameConverter;
import org.junit.Ignore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestAnnotations {
    private final Class<?> testClass;

    private TestAnnotations(Class<?> testClass) {
        this.testClass = testClass;
    }

    public static TestAnnotations forClass(Class<?> testClass) {
        return new TestAnnotations(testClass);
    }

    public String getAnnotatedTitleForMethod(String methodName) {
        String annotatedTitle = null;
        if (this.testClass != null && this.testClassHasMethodCalled(methodName)) {
            annotatedTitle = this.getAnnotatedTitle(methodName);
        }
        return annotatedTitle;
    }

    public boolean isPending(String methodName) {
        if (this.testClass != null && this.testClassHasMethodCalled(methodName)) {
            return TestAnnotations.isPending(this.getMethodCalled(methodName));
        }
        return false;
    }

    public static boolean isPending(Method method) {
        if (method != null) {
            return method.getAnnotation(Pending.class) != null;
        }
        return false;
    }

    public static boolean isIgnored(Method method) {
        if (method != null) {
            return method.getAnnotation(Ignore.class) != null;
        }
        return false;
    }

    public boolean isIgnored(String methodName) {
        if (this.testClass != null) {
            return TestAnnotations.isIgnored(this.getMethodCalled(methodName));
        }
        return false;
    }

    private String getAnnotatedTitle(String methodName) {
        Method testMethod = this.getMethodCalled(methodName);
        Title titleAnnotation = testMethod.getAnnotation(Title.class);
        if (titleAnnotation != null) {
            return titleAnnotation.value();
        }
        return null;
    }

    private boolean testClassHasMethodCalled(String methodName) {
        return this.getMethodCalled(methodName) != null;
    }

    private Method getMethodCalled(String methodName) {
        String baseMethodName = NameConverter.withNoArguments(methodName);
        try {
            return this.testClass.getMethod(baseMethodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

