/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class ErrorMessageFormatter {
    private final String originalMessage;
    Pattern LEADING_EXCEPTIONS = Pattern.compile("^<?[\\w\\.]*:\\s");

    public ErrorMessageFormatter(String originalMessage) {
        this.originalMessage = originalMessage;
    }

    public String getShortErrorMessage() {
        String[] lines = this.originalMessage.split("\\r?\\n");
        return StringUtils.trimToEmpty((String)this.replaceDoubleQuotes(this.removeLeadingExceptionFrom(lines[0])));
    }

    private String removeLeadingExceptionFrom(String message) {
        Matcher matcher = this.LEADING_EXCEPTIONS.matcher(message);
        if (matcher.find()) {
            return matcher.replaceFirst("");
        }
        return message;
    }

    private String replaceDoubleQuotes(String message) {
        return message.replaceAll("\"", "'");
    }
}

