/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.CoverageFormatter;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultList;
import net.thucydides.core.reports.html.Formatter;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryTestResults {
    private List<TestOutcome> testOutcomes = new ArrayList<TestOutcome>();
    private final String title;
    private final Story story;
    public final Integer DEFAULT_ESTIMATED_AVERAGE_STEP_COUNT = 5;

    public StoryTestResults(Story story) {
        this.title = story.getName();
        this.story = story;
    }

    public long getDuration() {
        return (Long)Lambda.sum(this.testOutcomes, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getDuration());
    }

    public Story getStory() {
        return this.story;
    }

    public String getReportName(ReportNamer.ReportType type) {
        ReportNamer reportNamer = new ReportNamer(type);
        return reportNamer.getNormalizedTestNameFor(this.getStory());
    }

    public String getReportName() {
        return this.getReportName(ReportNamer.ReportType.ROOT);
    }

    public void recordTestRun(TestOutcome testOutcome) {
        this.testOutcomes.add(testOutcome);
    }

    public int getTotal() {
        return this.testOutcomes.size();
    }

    public int getFailureCount() {
        return Lambda.select(this.testOutcomes, (Matcher)Lambda.having((Boolean)((TestOutcome)Lambda.on(TestOutcome.class)).isFailure())).size();
    }

    public Integer getSkipCount() {
        return Lambda.select(this.testOutcomes, (Matcher)Lambda.having((Boolean)((TestOutcome)Lambda.on(TestOutcome.class)).isSkipped())).size();
    }

    public int getSuccessCount() {
        return Lambda.select(this.testOutcomes, (Matcher)Lambda.having((Boolean)((TestOutcome)Lambda.on(TestOutcome.class)).isSuccess())).size();
    }

    public int countStepsInSuccessfulTests() {
        List successfulTests = Lambda.select(this.testOutcomes, (Matcher)Lambda.having((Boolean)((TestOutcome)Lambda.on(TestOutcome.class)).isSuccess()));
        try {
            return successfulTests.isEmpty() ? 0 : (Integer)Lambda.sum((Object)successfulTests, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getNestedStepCount());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int countStepsInFailingTests() {
        List tests = Lambda.select(this.testOutcomes, (Matcher)Lambda.having((Boolean)((TestOutcome)Lambda.on(TestOutcome.class)).isFailure()));
        try {
            return tests.isEmpty() ? 0 : (Integer)Lambda.sum((Object)tests, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getNestedStepCount());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int countStepsInSkippedTests() {
        List tests = Lambda.select(this.testOutcomes, (Matcher)Lambda.having((Boolean)((TestOutcome)Lambda.on(TestOutcome.class)).isSkipped()));
        try {
            return tests.isEmpty() ? 0 : (Integer)Lambda.sum((Object)tests, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getNestedStepCount());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getPendingCount() {
        return Lambda.select(this.testOutcomes, (Matcher)Lambda.having((Boolean)((TestOutcome)Lambda.on(TestOutcome.class)).isPending())).size();
    }

    public List<TestOutcome> getTestOutcomes() {
        return ImmutableList.copyOf(this.testOutcomes);
    }

    public String getTitle() {
        return StringUtils.capitalize((String)this.title);
    }

    public String getTitleWithLinks() {
        return this.getFormatter().addLinks(this.getTitle());
    }

    public String getFormattedIssues() {
        if (!this.getIssues().isEmpty()) {
            List orderedIssues = Lambda.sort(this.getIssues(), (Object)((String)Lambda.on(String.class)).toString());
            return "(" + this.getFormatter().addLinks(StringUtils.join((Collection)orderedIssues, (String)", ")) + ")";
        }
        return "";
    }

    public Set<String> getIssues() {
        List allIssues = Lambda.flatten((Object)Lambda.extract(this.testOutcomes, ((TestOutcome)Lambda.on(TestOutcome.class)).getIssues()));
        return new HashSet<String>(allIssues);
    }

    private Formatter getFormatter() {
        return new Formatter(ThucydidesSystemProperty.getIssueTrackerUrl());
    }

    public int getStepCount() {
        return Lambda.sum((Object)Lambda.extract(this.testOutcomes, (Object)((TestOutcome)Lambda.on(TestOutcome.class)).getNestedStepCount())).intValue();
    }

    public Double getCoverage() {
        if (this.getEstimatedTotalStepCount() == 0) {
            return 0.0;
        }
        return (double)this.passingOrFailingSteps() / (double)this.getEstimatedTotalStepCount().intValue();
    }

    public Double getPercentPassingCoverage() {
        if (this.getEstimatedTotalStepCount() == 0) {
            return 0.0;
        }
        return (double)this.countStepsInSuccessfulTests() / (double)this.getEstimatedTotalStepCount().intValue();
    }

    public Double getPercentFailingCoverage() {
        if (this.getEstimatedTotalStepCount() == 0) {
            return 0.0;
        }
        return (double)this.countStepsInFailingTests() / (double)this.getEstimatedTotalStepCount().intValue();
    }

    public Double getPercentPendingCoverage() {
        if (this.getEstimatedTotalStepCount() == 0) {
            return 0.0;
        }
        return (double)(this.getEstimatedTotalStepCount() - this.passingOrFailingSteps()) / (double)this.getEstimatedTotalStepCount().intValue();
    }

    public Integer getEstimatedTotalStepCount() {
        return this.getStepCount() + this.estimatedUnimplementedStepCount();
    }

    private Integer estimatedUnimplementedStepCount() {
        return (int)Math.round(this.getAverageTestSize() * (double)this.totalUnimplementedTests());
    }

    private int passingOrFailingSteps() {
        return this.countStepsInSuccessfulTests() + this.countStepsInFailingTests();
    }

    public double getAverageTestSize() {
        if (this.totalImplementedTests() > 0) {
            return (double)this.getStepCount() / (double)this.totalImplementedTests();
        }
        return ThucydidesSystemProperty.getIntegerValue(ThucydidesSystemProperty.ESTIMATED_AVERAGE_STEP_COUNT, this.DEFAULT_ESTIMATED_AVERAGE_STEP_COUNT).intValue();
    }

    private int totalUnimplementedTests() {
        return this.getTotal() - this.totalImplementedTests();
    }

    private int totalImplementedTests() {
        int testCount = 0;
        for (TestOutcome testOutcome : this.testOutcomes) {
            if (testOutcome.getTestSteps().isEmpty()) continue;
            ++testCount;
        }
        return testCount;
    }

    private List<TestResult> getCurrentTestResults() {
        return Lambda.convert(this.getTestOutcomes(), (Converter)new ExtractTestResultsConverter());
    }

    public TestResult getResult() {
        TestResultList testResults = new TestResultList(this.getCurrentTestResults());
        return testResults.getOverallResult();
    }

    public boolean containsResultsFor(Story aUserStory) {
        return this.getStory().equals(aUserStory);
    }

    public CoverageFormatter getFormatted() {
        return new CoverageFormatter(this.getPercentPassingCoverage(), this.getPercentPendingCoverage(), this.getPercentFailingCoverage());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtractTestResultsConverter
    implements Converter<TestOutcome, TestResult> {
        private ExtractTestResultsConverter() {
        }

        public TestResult convert(TestOutcome step) {
            return step.getResult();
        }
    }
}

