/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.history;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.StreamException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.FeatureResults;
import net.thucydides.core.reports.html.history.TestResultSnapshot;
import net.thucydides.core.util.EnvironmentVariables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestHistory {
    private static final String BUILD_ID = "BUILD_ID";
    private final File dataDirectory = new File(this.getBaseDirectoryPath());
    private final String projectName;
    protected EnvironmentVariables environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);

    public TestHistory(String projectName) {
        this.projectName = projectName;
    }

    private String getBaseDirectoryPath() {
        String defaultBaseDirectory = new File(this.homeDirectory(), ".thucydides").getAbsolutePath();
        return ThucydidesSystemProperty.getValue(ThucydidesSystemProperty.HISTORY_BASE_DIRECTORY, defaultBaseDirectory);
    }

    private String homeDirectory() {
        return System.getProperty("user.home");
    }

    public void updateData(List<FeatureResults> featureResults) {
        int totalStepCount = this.countTotalStepsIn(featureResults);
        int passingSteps = this.countPassingStepsIn(featureResults);
        int failingSteps = this.countFailingStepsIn(featureResults);
        int skippedSteps = this.countSkippedStepsIn(featureResults);
        String buildId = this.getEnvironmentVariables().getValue(BUILD_ID, "MANUAL");
        TestResultSnapshot newSnapshot = new TestResultSnapshot(totalStepCount, passingSteps, failingSteps, skippedSteps, buildId);
        try {
            this.save(newSnapshot);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Unable to store history data", e);
        }
    }

    private int countTotalStepsIn(List<FeatureResults> featureResults) {
        int total = 0;
        for (FeatureResults results : featureResults) {
            total += results.getEstimatedTotalSteps().intValue();
        }
        return total;
    }

    private int countPassingStepsIn(List<FeatureResults> featureResults) {
        int total = 0;
        for (FeatureResults results : featureResults) {
            total += results.getPassingSteps().intValue();
        }
        return total;
    }

    private int countFailingStepsIn(List<FeatureResults> featureResults) {
        int total = 0;
        for (FeatureResults results : featureResults) {
            total += results.getFailingSteps().intValue();
        }
        return total;
    }

    private int countSkippedStepsIn(List<FeatureResults> featureResults) {
        int total = 0;
        for (FeatureResults results : featureResults) {
            total += results.getSkippedSteps().intValue();
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(TestResultSnapshot snapshot) throws FileNotFoundException {
        XStream xstream = new XStream();
        File snapshotFile = new File(this.getDirectory(), this.historyPrefix() + snapshot.getTime().getMillis());
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(snapshotFile);
            xstream.toXML((Object)snapshot, (OutputStream)out);
        }
        finally {
            this.close(out);
        }
    }

    private void close(Closeable stream) {
        try {
            stream.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to close history file", e);
        }
    }

    public File getDirectory() {
        File projectDirectory = new File(this.dataDirectory, this.projectName);
        if (!projectDirectory.exists()) {
            projectDirectory.mkdirs();
        }
        return projectDirectory;
    }

    public List<TestResultSnapshot> getHistory() {
        File[] historyFiles = this.getHistoryFiles();
        ArrayList<TestResultSnapshot> resultSnapshots = new ArrayList<TestResultSnapshot>();
        XStream xstream = new XStream();
        for (File historyFile : historyFiles) {
            TestResultSnapshot snapshot = null;
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(historyFile);
                snapshot = (TestResultSnapshot)xstream.fromXML((InputStream)inputStream);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("Unable to read history data in " + historyFile, e);
            }
            catch (StreamException streamException) {
                throw new IllegalArgumentException("Unable to parse history data in " + historyFile, streamException);
            }
            finally {
                this.close(inputStream);
            }
            resultSnapshots.add(snapshot);
        }
        Collections.sort(resultSnapshots);
        return resultSnapshots;
    }

    private File[] getHistoryFiles() {
        return this.getDirectory().listFiles(new FilenameFilter(){

            public boolean accept(File directory, String filename) {
                return filename.startsWith(TestHistory.this.historyPrefix());
            }
        });
    }

    private String historyPrefix() {
        return "thucydides-";
    }

    public void clearHistory() {
        File[] historyFiles;
        for (File historyFile : historyFiles = this.getHistoryFiles()) {
            historyFile.delete();
        }
    }

    protected EnvironmentVariables getEnvironmentVariables() {
        return this.environmentVariables;
    }

    protected void setEnvironmentVariables(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }
}

