/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.regex.Pattern;
import net.thucydides.core.resources.FileResources;
import net.thucydides.core.resources.ResourceList;

public class HtmlResourceCopier {
    private String resourceDirectory;

    public HtmlResourceCopier(String resourceDirectory) {
        this.resourceDirectory = resourceDirectory;
    }

    public void copyHTMLResourcesTo(File targetDirectory) throws IOException {
        Pattern resourcePattern = this.allFilesInDirectory(this.resourceDirectory);
        FileResources fileResource = FileResources.from(this.resourceDirectory);
        Collection<String> reportResources = ResourceList.getResources(resourcePattern);
        for (String resourcePath : reportResources) {
            if (this.fileResourceFromAJar(resourcePath)) {
                fileResource.copyResourceTo(resourcePath, targetDirectory);
                continue;
            }
            if (!this.fileResourceFromPath(resourcePath)) continue;
            fileResource.copyResourceTo(resourcePath, targetDirectory);
        }
    }

    private boolean fileResourceFromAJar(String resourcePath) {
        return this.resourceIsFromAJar(resourcePath) && this.thisIsNotTheRoot(resourcePath) && this.thisIsNotADirectory(resourcePath);
    }

    private boolean fileResourceFromPath(String resourcePath) {
        boolean res = !this.resourceIsFromAJar(resourcePath) && this.thisIsNotTheRoot(resourcePath) && this.thisIsNotADirectory(resourcePath);
        return res;
    }

    private boolean thisIsNotADirectory(String resourcePath) {
        return !resourcePath.endsWith("/");
    }

    private boolean thisIsNotTheRoot(String resourcePath) {
        return !this.resourceDirectory.equals(resourcePath);
    }

    private Pattern allFilesInDirectory(String directory) {
        String allFilesPattern = String.format(".*[\\\\/]?%s[\\\\/].*", directory);
        return Pattern.compile(allFilesPattern);
    }

    private boolean resourceIsFromAJar(String resourcePath) {
        return !resourcePath.startsWith("/");
    }
}

