/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.thucydides.core.images.ResizableImage;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.Screenshot;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.reports.html.HtmlReporter;
import net.thucydides.core.reports.html.screenshots.ScreenshotFormatter;
import net.thucydides.core.screenshots.ScreenshotException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlAcceptanceTestReporter
extends HtmlReporter
implements AcceptanceTestReporter {
    private static final String DEFAULT_ACCEPTANCE_TEST_REPORT = "freemarker/default.ftl";
    private static final String DEFAULT_ACCEPTANCE_TEST_SCREENSHOT = "freemarker/screenshots.ftl";
    private static final int MAXIMUM_SCREENSHOT_WIDTH = 1000;
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlAcceptanceTestReporter.class);
    private String qualifier;

    @Override
    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    @Override
    public String getName() {
        return "html";
    }

    @Override
    public File generateReportFor(TestOutcome testOutcome) throws IOException {
        Preconditions.checkNotNull((Object)this.getOutputDirectory());
        HashMap<String, Object> context = new HashMap<String, Object>();
        this.addTestOutcomeToContext(testOutcome, context);
        this.addFormattersToContext(context);
        String htmlContents = this.mergeTemplate(DEFAULT_ACCEPTANCE_TEST_REPORT).usingContext(context);
        this.copyResourcesToOutputDirectory();
        this.generateScreenshotReportsFor(testOutcome);
        String reportFilename = this.reportFor(testOutcome);
        return this.writeReportToOutputDirectory(reportFilename, htmlContents);
    }

    private void addTestOutcomeToContext(TestOutcome testOutcome, Map<String, Object> context) {
        context.put("testOutcome", testOutcome);
    }

    private void addFormattersToContext(Map<String, Object> context) {
        Formatter formatter = new Formatter(IssueTracking.getIssueTrackerUrl());
        context.put("formatter", formatter);
    }

    private void generateScreenshotReportsFor(TestOutcome testOutcome) throws IOException {
        Preconditions.checkNotNull((Object)this.getOutputDirectory());
        List<Screenshot> screenshots = this.expandScreenshots(testOutcome.getScreenshots());
        String screenshotReport = testOutcome.getReportName() + "_screenshots.html";
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("screenshots", screenshots);
        context.put("testOutcome", testOutcome);
        String htmlContents = this.mergeTemplate(DEFAULT_ACCEPTANCE_TEST_SCREENSHOT).usingContext(context);
        this.writeReportToOutputDirectory(screenshotReport, htmlContents);
    }

    private List<Screenshot> expandScreenshots(List<Screenshot> screenshots) throws IOException {
        return Lambda.convert(screenshots, (Converter)new ExpandedScreenshotConverter(this.maxScreenshotHeightIn(screenshots)));
    }

    private int maxScreenshotHeightIn(List<Screenshot> screenshots) throws IOException {
        int maxHeight = 0;
        for (Screenshot screenshot : screenshots) {
            File screenshotFile = new File(this.getOutputDirectory(), screenshot.getFilename());
            if (!screenshotFile.exists()) continue;
            maxHeight = this.maxHeightOf(maxHeight, screenshotFile);
        }
        return maxHeight;
    }

    private int maxHeightOf(int maxHeight, File screenshotFile) throws IOException {
        int height = ResizableImage.loadFrom(screenshotFile).getHeight();
        int width = ResizableImage.loadFrom(screenshotFile).getWitdh();
        if (width > 1000) {
            height = (int)((double)height * 1.0 * (1000.0 / (double)width));
        }
        if (height > maxHeight) {
            maxHeight = height;
        }
        return maxHeight;
    }

    private String reportFor(TestOutcome testOutcome) {
        if (this.qualifier != null) {
            return testOutcome.getReportName(ReportNamer.ReportType.HTML, this.qualifier);
        }
        return testOutcome.getReportName(ReportNamer.ReportType.HTML);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExpandedScreenshotConverter
    implements Converter<Screenshot, Screenshot> {
        private final int maxHeight;

        public ExpandedScreenshotConverter(int maxHeight) {
            this.maxHeight = maxHeight;
        }

        public Screenshot convert(Screenshot screenshot) {
            try {
                return ScreenshotFormatter.forScreenshot(screenshot).inDirectory(HtmlAcceptanceTestReporter.this.getOutputDirectory()).expandToHeight(this.maxHeight);
            }
            catch (IOException e) {
                LOGGER.error("Failed to write scaled screenshot for {}: {}", (Object)screenshot, (Object)e);
                throw new ScreenshotException("Failed to write scaled screenshot", e);
            }
        }
    }
}

