/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core;

import java.io.File;
import net.thucydides.core.annotations.TestCaseAnnotations;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFactory;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.WebdriverManager;
import org.openqa.selenium.WebDriver;

public class Thucydides {
    private static final ThreadLocal<WebDriverFactory> factoryThreadLocal = new ThreadLocal();
    private static final ThreadLocal<WebdriverManager> webdriverManagerThreadLocal = new ThreadLocal();
    private static final ThreadLocal<Pages> pagesThreadLocal = new ThreadLocal();
    private static final ThreadLocal<StepFactory> stepFactoryThreadLocal = new ThreadLocal();
    private static final ThreadLocal<StepListener> stepListenerThreadLocal = new ThreadLocal();

    public static void initialize(Object testCase) {
        Thucydides.setupWebDriverFactory();
        Thucydides.setupWebdriverManager();
        Thucydides.initPagesObjectUsing(Thucydides.getDriver());
        Thucydides.initStepListener();
        Thucydides.initStepFactoryUsing(Thucydides.getPages());
        Thucydides.injectDriverInto(testCase);
        Thucydides.injectAnnotatedPagesObjectInto(testCase);
        Thucydides.injectScenarioStepsInto(testCase);
    }

    private static void initStepListener() {
        File outputDirectory = Configuration.loadOutputDirectoryFromSystemProperties();
        BaseStepListener listener = new BaseStepListener(outputDirectory, Thucydides.getPages());
        stepListenerThreadLocal.set(listener);
        StepEventBus.getEventBus().registerListener(Thucydides.getStepListener());
    }

    private static void setupWebDriverFactory() {
        factoryThreadLocal.set(new WebDriverFactory());
    }

    private static void initPagesObjectUsing(WebDriver driver) {
        pagesThreadLocal.set(new Pages(driver));
    }

    private static void initStepFactoryUsing(Pages pagesObject) {
        stepFactoryThreadLocal.set(new StepFactory(pagesObject));
    }

    protected static void injectDriverInto(Object testCase) {
        TestCaseAnnotations.forTestCase(testCase).injectDriver(Thucydides.getDriver());
    }

    protected static void injectScenarioStepsInto(Object testCase) {
        StepAnnotations.injectScenarioStepsInto(testCase, Thucydides.getStepFactory());
    }

    protected static void injectAnnotatedPagesObjectInto(Object testCase) {
        Thucydides.getPages().notifyWhenDriverOpens();
        StepAnnotations.injectAnnotatedPagesObjectInto(testCase, Thucydides.getPages());
    }

    public static void done(Object testClass) {
        Thucydides.getWebdriverManager().closeDriver();
    }

    protected static WebDriver getDriver() {
        return Thucydides.getWebdriverManager().getWebdriver();
    }

    protected static Pages getPages() {
        return pagesThreadLocal.get();
    }

    protected static void useMockDriver(final WebDriver mockDriver) {
        Thucydides.setupWebdriverManager(new WebdriverManager(Thucydides.getWebDriverFactory()){

            public WebDriver getWebdriver() {
                return mockDriver;
            }
        });
    }

    protected static void stopUsingMockDriver() {
        Thucydides.setupWebdriverManager();
    }

    private static WebdriverManager getWebdriverManager() {
        return webdriverManagerThreadLocal.get();
    }

    private static WebDriverFactory getWebDriverFactory() {
        return factoryThreadLocal.get();
    }

    private static StepFactory getStepFactory() {
        return stepFactoryThreadLocal.get();
    }

    private static void setupWebdriverManager() {
        Thucydides.setupWebdriverManager(new WebdriverManager(Thucydides.getWebDriverFactory()));
    }

    private static void setupWebdriverManager(WebdriverManager webdriverManager) {
        webdriverManagerThreadLocal.set(webdriverManager);
    }

    public static StepListener getStepListener() {
        return stepListenerThreadLocal.get();
    }
}

