/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.csv;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import net.thucydides.core.csv.FailedToInitializeTestData;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InstanceBuilder {
    private Object targetObject;

    private <T> InstanceBuilder(T newObject) {
        this.targetObject = newObject;
    }

    public static <T> T newInstanceOf(Class<T> clazz, Object ... constructorArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (constructorArgs.length == 0 && InstanceBuilder.thereIsADefaultConstructorFor(clazz)) {
            return clazz.newInstance();
        }
        return InstanceBuilder.invokeConstructorFor(clazz, constructorArgs);
    }

    public static <T> T invokeConstructorFor(Class<T> clazz, Object[] constructorArgs) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = clazz.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != constructorArgs.length) continue;
            return (T)constructor.newInstance(constructorArgs);
        }
        throw new IllegalStateException("No matching constructor found for " + clazz + " with arguments: " + ArrayUtils.toString((Object)constructorArgs));
    }

    private static <T> boolean thereIsADefaultConstructorFor(Class<T> clazz) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = clazz.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }

    public void setPropertyValue(String property, String value) {
        if (PropertyUtils.isWriteable((Object)this.targetObject, (String)property)) {
            this.setPropertyValueViaSetter(property, value);
        } else {
            this.setFieldValueDirectly(property, value);
        }
    }

    private void setPropertyValueViaSetter(String property, String value) {
        try {
            PropertyUtils.setProperty((Object)this.targetObject, (String)property, (Object)value);
        }
        catch (Exception e) {
            throw new FailedToInitializeTestData("Could not assign property value using setter", e);
        }
    }

    private void setFieldValueDirectly(String property, String value) {
        try {
            Field field = this.findField(property);
            field.set(this.targetObject, value);
        }
        catch (Exception e) {
            throw new FailedToInitializeTestData("Could not assign property value", e);
        }
    }

    private Field findField(String property) {
        Field[] fields;
        for (Field field : fields = this.targetObject.getClass().getFields()) {
            if (!field.getName().equals(property)) continue;
            return field;
        }
        throw new FailedToInitializeTestData("Could not find property called " + property);
    }

    public static <T> InstanceBuilder inObject(T newObject) {
        return new InstanceBuilder(newObject);
    }
}

