/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.junit.rules;

import java.util.HashMap;
import java.util.Map;
import net.thucydides.core.ThucydidesSystemProperty;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveWebdriverSystemPropertiesRule
implements MethodRule {
    private final Map<String, String> originalValues = this.saveWebdriverSystemProperties();

    private Map<String, String> saveWebdriverSystemProperties() {
        HashMap<String, String> systemPropertyValues = new HashMap<String, String>();
        for (ThucydidesSystemProperty property : ThucydidesSystemProperty.values()) {
            SaveWebdriverSystemPropertiesRule.savePropertyValueFor(property, systemPropertyValues);
        }
        return systemPropertyValues;
    }

    private static void savePropertyValueFor(ThucydidesSystemProperty property, Map<String, String> originalValues) {
        String propertyName = property.getPropertyName();
        String currentValue = System.getProperty(propertyName);
        if (currentValue != null) {
            originalValues.put(propertyName, currentValue);
        }
    }

    public Statement apply(Statement statement, FrameworkMethod method, Object target) {
        return new RestorePropertiesStatement(statement, this.originalValues);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RestorePropertiesStatement
    extends Statement {
        private final Statement statement;
        private final Map<String, String> originalValues;

        private RestorePropertiesStatement(Statement statement, Map<String, String> originalValues) {
            this.statement = statement;
            this.originalValues = originalValues;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            try {
                this.statement.evaluate();
            }
            finally {
                this.restoreOldSystemProperties();
            }
        }

        private void restoreOldSystemProperties() {
            for (ThucydidesSystemProperty property : ThucydidesSystemProperty.values()) {
                this.restorePropertyValueFor(property);
            }
        }

        private void restorePropertyValueFor(ThucydidesSystemProperty property) {
            String propertyName = property.getPropertyName();
            if (this.originalValues.containsKey(propertyName)) {
                String originalValue = this.originalValues.get(propertyName);
                System.setProperty(propertyName, originalValue);
            } else {
                System.clearProperty(propertyName);
            }
        }
    }
}

