/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import net.thucydides.core.annotations.TestAnnotations;
import net.thucydides.core.images.SimpleImageInfo;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.Screenshot;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultList;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.model.features.ApplicationFeature;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestOutcome {
    private final String methodName;
    private final Class<?> testCase;
    private final List<TestStep> testSteps = new ArrayList<TestStep>();
    private Story userStory;
    private String storedTitle;
    private Set<String> issues;
    private long duration;
    private final long startTime;
    private Throwable testFailureCause;
    private TestResult annotatedResult = null;
    private Stack<TestStep> groupStack = new Stack();

    public TestOutcome(String methodName) {
        this(methodName, null);
    }

    public TestOutcome(String methodName, Class<?> testCase) {
        this.startTime = System.currentTimeMillis();
        this.methodName = methodName;
        this.testCase = testCase;
        if (testCase != null) {
            this.initializeStoryFrom(testCase);
        }
    }

    protected TestOutcome(String methodName, Class<?> testCase, Story userStory) {
        this.startTime = System.currentTimeMillis();
        this.methodName = methodName;
        this.testCase = testCase;
        this.userStory = userStory;
    }

    public static TestOutcome forTest(String methodName, Class<?> testCase) {
        return new TestOutcome(methodName, testCase);
    }

    private void initializeStoryFrom(Class<?> testCase) {
        Story story = Story.testedInTestCase(testCase) != null ? Story.from(Story.testedInTestCase(testCase)) : Story.from(testCase);
        this.setUserStory(story);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public static TestOutcome forTestInStory(String testName, Story story) {
        return new TestOutcome(testName, null, story);
    }

    public static TestOutcome forTestInStory(String testName, Class<?> testCase, Story story) {
        return new TestOutcome(testName, testCase, story);
    }

    public String toString() {
        return Lambda.join((Object)Lambda.extract(this.testSteps, (Object)((TestStep)Lambda.on(TestStep.class)).toString()));
    }

    public String getTitle() {
        if (this.storedTitle == null) {
            return this.obtainTitleFromAnnotationOrMethodName();
        }
        return this.storedTitle;
    }

    public String getTitleWithLinks() {
        return this.getFormatter().addLinks(this.getTitle());
    }

    private Formatter getFormatter() {
        return new Formatter(IssueTracking.getIssueTrackerUrl());
    }

    private String obtainTitleFromAnnotationOrMethodName() {
        String annotatedTitle = TestAnnotations.forClass(this.testCase).getAnnotatedTitleForMethod(this.methodName);
        if (annotatedTitle != null) {
            return annotatedTitle;
        }
        return NameConverter.humanize(NameConverter.withNoArguments(this.methodName));
    }

    public String getStoryTitle() {
        return this.getTitleFrom(this.userStory);
    }

    private String getTitleFrom(Story userStory) {
        return userStory.getName();
    }

    public String getReportName(ReportNamer.ReportType type) {
        ReportNamer reportNamer = new ReportNamer(type);
        return reportNamer.getNormalizedTestNameFor(this);
    }

    public String getReportName(ReportNamer.ReportType type, String qualifier) {
        ReportNamer reportNamer = new ReportNamer(type);
        if (qualifier == null) {
            return reportNamer.getNormalizedTestNameFor(this);
        }
        return reportNamer.getNormalizedTestNameFor(this, qualifier);
    }

    public String getReportName() {
        return this.getReportName(ReportNamer.ReportType.ROOT);
    }

    public String getScreenshotReportName() {
        return this.getReportName(ReportNamer.ReportType.ROOT) + "_screenshots";
    }

    public List<TestStep> getTestSteps() {
        return ImmutableList.copyOf(this.testSteps);
    }

    public List<Screenshot> getScreenshots() {
        ArrayList<Screenshot> screenshots = new ArrayList<Screenshot>();
        List<TestStep> testSteps = this.getFlattenedTestSteps();
        for (TestStep currentStep : testSteps) {
            if (currentStep.isAGroup() || currentStep.getScreenshot() == null) continue;
            screenshots.add(new Screenshot(currentStep.getScreenshot().getName(), currentStep.getDescription(), this.widthOf(currentStep.getScreenshot()), currentStep.getException()));
        }
        return ImmutableList.copyOf(screenshots);
    }

    private int widthOf(File screenshot) {
        try {
            return new SimpleImageInfo(screenshot).getWidth();
        }
        catch (IOException e) {
            return 800;
        }
    }

    public List<TestStep> getFlattenedTestSteps() {
        ArrayList<? extends TestStep> flattenedTestSteps = new ArrayList<TestStep>();
        for (TestStep step : this.getTestSteps()) {
            flattenedTestSteps.add(step);
            if (!step.isAGroup()) continue;
            flattenedTestSteps.addAll(step.getFlattenedSteps());
        }
        return ImmutableList.copyOf(flattenedTestSteps);
    }

    public List<TestStep> getLeafTestSteps() {
        ArrayList<? extends TestStep> leafTestSteps = new ArrayList<TestStep>();
        for (TestStep step : this.getTestSteps()) {
            if (step.isAGroup()) {
                leafTestSteps.addAll(step.getLeafTestSteps());
                continue;
            }
            leafTestSteps.add(step);
        }
        return ImmutableList.copyOf(leafTestSteps);
    }

    public TestResult getResult() {
        if (this.testFailureCause != null) {
            return TestResult.FAILURE;
        }
        if (this.annotatedResult != null) {
            return this.annotatedResult;
        }
        TestResultList testResults = new TestResultList(this.getCurrentTestResults());
        return testResults.getOverallResult();
    }

    public void recordStep(TestStep step) {
        Preconditions.checkNotNull((Object)step.getDescription(), (Object)"The test step description was not defined.");
        if (this.inGroup()) {
            this.getCurrentStepGroup().addChildStep(step);
        } else {
            this.testSteps.add(step);
        }
    }

    private TestStep getCurrentStepGroup() {
        return this.groupStack.peek();
    }

    private boolean inGroup() {
        return !this.groupStack.empty();
    }

    public ApplicationFeature getFeature() {
        if (this.getUserStory() != null) {
            return this.obtainFeatureFromUserStory();
        }
        return null;
    }

    private ApplicationFeature obtainFeatureFromUserStory() {
        return this.getUserStory().getFeature();
    }

    public void setTitle(String title) {
        this.storedTitle = title;
    }

    private List<TestResult> getCurrentTestResults() {
        return Lambda.convert(this.testSteps, (Converter)new ExtractTestResultsConverter());
    }

    @Deprecated
    public void startGroup(String groupName) {
        this.recordStep(new TestStep(groupName));
        this.startGroup();
    }

    public void startGroup() {
        if (!this.testSteps.isEmpty()) {
            this.groupStack.push(this.getCurrentStep());
        }
    }

    public void endGroup() {
        if (!this.groupStack.isEmpty()) {
            this.groupStack.pop();
        }
    }

    public TestStep getCurrentStep() {
        Preconditions.checkState((!this.testSteps.isEmpty() ? 1 : 0) != 0);
        if (!this.inGroup()) {
            return this.lastStepIn(this.testSteps);
        }
        TestStep currentStepGroup = this.groupStack.peek();
        return this.lastStepIn(currentStepGroup.getChildren());
    }

    private TestStep lastStepIn(List<TestStep> testSteps) {
        return testSteps.get(testSteps.size() - 1);
    }

    public TestStep getCurrentGroup() {
        Preconditions.checkState((boolean)this.inGroup());
        return this.groupStack.peek();
    }

    public void setUserStory(Story story) {
        this.userStory = story;
    }

    public void setTestFailureCause(Throwable cause) {
        this.testFailureCause = cause;
    }

    public Throwable getTestFailureCause() {
        return this.testFailureCause;
    }

    public void setAnnotatedResult(TestResult annotatedResult) {
        this.annotatedResult = annotatedResult;
    }

    public Set<String> getIssues() {
        if (this.issues == null) {
            this.issues = this.readIssues();
        }
        return this.issues;
    }

    private Set<String> readIssues() {
        HashSet<String> taggedIssues = new HashSet<String>();
        if (this.testCase != null) {
            this.addMethodLevelIssuesTo(taggedIssues);
            this.addClassLevelIssuesTo(taggedIssues);
        }
        return taggedIssues;
    }

    private void addClassLevelIssuesTo(Set<String> issues) {
        String[] classIssues;
        String classIssue = TestAnnotations.forClass(this.testCase).getAnnotatedIssueForTestCase(this.testCase);
        if (classIssue != null) {
            issues.add(classIssue);
        }
        if ((classIssues = TestAnnotations.forClass(this.testCase).getAnnotatedIssuesForTestCase(this.testCase)) != null) {
            issues.addAll(Arrays.asList(classIssues));
        }
    }

    private void addMethodLevelIssuesTo(Set<String> issues) {
        String[] multipleIssues;
        String issue = TestAnnotations.forClass(this.testCase).getAnnotatedIssueForMethod(this.getMethodName());
        if (issue != null) {
            issues.add(issue);
        }
        if ((multipleIssues = TestAnnotations.forClass(this.testCase).getAnnotatedIssuesForMethod(this.getMethodName())) != null) {
            issues.addAll(Arrays.asList(multipleIssues));
        }
    }

    public String getFormattedIssues() {
        Set<String> issues = this.getIssues();
        if (!issues.isEmpty()) {
            List orderedIssues = Lambda.sort(this.getIssues(), (Object)((String)Lambda.on(String.class)).toString());
            return "(" + this.getFormatter().addLinks(StringUtils.join((Collection)orderedIssues, (String)", ")) + ")";
        }
        return "";
    }

    public void isRelatedToIssue(String issue) {
        this.getIssues().add(issue);
    }

    public Integer getStepCount() {
        return this.testSteps.size();
    }

    public Integer getNestedStepCount() {
        return this.getFlattenedTestSteps().size();
    }

    public Integer getSuccessCount() {
        List<TestStep> allTestSteps = this.getLeafTestSteps();
        return Lambda.select(allTestSteps, (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).isSuccessful())).size();
    }

    public Integer getFailureCount() {
        List<TestStep> allTestSteps = this.getLeafTestSteps();
        return Lambda.select(allTestSteps, (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).isFailure())).size();
    }

    public Integer getIgnoredCount() {
        List<TestStep> allTestSteps = this.getLeafTestSteps();
        return Lambda.select(allTestSteps, (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).isIgnored())).size();
    }

    public Integer getSkippedCount() {
        List<TestStep> allTestSteps = this.getLeafTestSteps();
        return Lambda.select(allTestSteps, (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).isSkipped())).size();
    }

    public Integer getPendingCount() {
        List<TestStep> allTestSteps = this.getLeafTestSteps();
        return Lambda.select(allTestSteps, (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).isPending())).size();
    }

    public Boolean isSuccess() {
        return this.getResult() == TestResult.SUCCESS;
    }

    public Boolean isFailure() {
        return this.getResult() == TestResult.FAILURE;
    }

    public Boolean isPending() {
        return this.getResult() == TestResult.PENDING;
    }

    public Boolean isSkipped() {
        return this.getResult() == TestResult.SKIPPED || this.getResult() == TestResult.IGNORED;
    }

    public Story getUserStory() {
        return this.userStory;
    }

    public void recordDuration() {
        this.setDuration(System.currentTimeMillis() - this.startTime);
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getDuration() {
        if (this.duration == 0L && this.testSteps != null && this.testSteps.size() > 0) {
            return (Long)Lambda.sum(this.testSteps, (Object)((TestStep)Lambda.on(TestStep.class)).getDuration());
        }
        return this.duration;
    }

    public Integer countTestSteps() {
        return this.countLeafStepsIn(this.testSteps);
    }

    private Integer countLeafStepsIn(List<TestStep> testSteps) {
        int leafCount = 0;
        for (TestStep step : testSteps) {
            if (step.isAGroup()) {
                leafCount += this.countLeafStepsIn(step.getChildren()).intValue();
                continue;
            }
            ++leafCount;
        }
        return leafCount;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtractTestResultsConverter
    implements Converter<TestStep, TestResult> {
        private ExtractTestResultsConverter() {
        }

        public TestResult convert(TestStep step) {
            return step.getResult();
        }
    }
}

