/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import java.io.File;
import java.util.Locale;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.UnsupportedDriverException;

public class Configuration {
    public static final String WEBDRIVER_DRIVER = ThucydidesSystemProperty.DRIVER.getPropertyName();
    public static final String DEFAULT_WEBDRIVER_DRIVER = "firefox";
    public static final int DEFAULT_ELEMENT_TIMEOUT_SECONDS = 5;
    public static final String OUTPUT_DIRECTORY_PROPERTY = ThucydidesSystemProperty.OUTPUT_DIRECTORY.getPropertyName();
    public static final String ASSUME_UNTRUSTED_CERTIFICATE_ISSUER = ThucydidesSystemProperty.ASSUME_UNTRUSTED_CERTIFICATE_ISSUER.getPropertyName();
    private static final String DEFAULT_OUTPUT_DIRECTORY = "target/site/thucydides";
    private File outputDirectory;

    public static SupportedWebDriver getDriverType() {
        String driverType = System.getProperty(WEBDRIVER_DRIVER, DEFAULT_WEBDRIVER_DRIVER);
        return Configuration.lookupSupportedDriverTypeFor(driverType);
    }

    public static File loadOutputDirectoryFromSystemProperties() {
        String systemDefinedDirectory = System.getProperty(OUTPUT_DIRECTORY_PROPERTY);
        if (systemDefinedDirectory == null) {
            systemDefinedDirectory = DEFAULT_OUTPUT_DIRECTORY;
        }
        return new File(systemDefinedDirectory);
    }

    public static int getStepDelay() {
        int stepDelay = 0;
        String stepDelayValue = System.getProperty(ThucydidesSystemProperty.STEP_DELAY.getPropertyName());
        if (stepDelayValue != null && !stepDelayValue.isEmpty()) {
            stepDelay = Integer.valueOf(stepDelayValue);
        }
        return stepDelay;
    }

    public static int getElementTimeout() {
        int elementTimeout = 5;
        String stepDelayValue = System.getProperty(ThucydidesSystemProperty.ELEMENT_TIMEOUT.getPropertyName());
        if (stepDelayValue != null && !stepDelayValue.isEmpty()) {
            elementTimeout = Integer.valueOf(stepDelayValue);
        }
        return elementTimeout;
    }

    public static boolean getUseUniqueBrowser() {
        boolean uniqueBrowser = false;
        String uniqueBrowserValue = System.getProperty(ThucydidesSystemProperty.UNIQUE_BROWSER.getPropertyName());
        if (uniqueBrowserValue != null) {
            uniqueBrowser = Boolean.valueOf(uniqueBrowserValue);
        }
        return uniqueBrowser;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public File getOutputDirectory() {
        this.outputDirectory = Configuration.loadOutputDirectoryFromSystemProperties();
        this.outputDirectory.mkdirs();
        return this.outputDirectory;
    }

    private static SupportedWebDriver lookupSupportedDriverTypeFor(String driverType) {
        SupportedWebDriver driver = null;
        try {
            driver = SupportedWebDriver.valueOf(driverType.toUpperCase(Locale.getDefault()));
        }
        catch (IllegalArgumentException iae) {
            Configuration.throwUnsupportedDriverExceptionFor(driverType);
        }
        return driver;
    }

    private static void throwUnsupportedDriverExceptionFor(String driverType) {
        throw new UnsupportedDriverException(driverType + " is not a supported browser. Supported driver values are: " + SupportedWebDriver.listOfSupportedDrivers());
    }
}

