/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.thucydides.core.annotations.Issue;
import net.thucydides.core.annotations.Issues;
import net.thucydides.core.annotations.Pending;
import net.thucydides.core.annotations.Title;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.util.NameConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestAnnotations {
    private final Class<?> testClass;

    private TestAnnotations(Class<?> testClass) {
        this.testClass = testClass;
    }

    public static TestAnnotations forClass(Class<?> testClass) {
        return new TestAnnotations(testClass);
    }

    public String getAnnotatedTitleForMethod(String methodName) {
        String annotatedTitle = null;
        if (this.testClass != null && this.testClassHasMethodCalled(methodName)) {
            annotatedTitle = this.getAnnotatedTitle(methodName);
        }
        return annotatedTitle;
    }

    public boolean isPending(String methodName) {
        if (this.testClass != null && this.testClassHasMethodCalled(methodName)) {
            return TestAnnotations.isPending(this.getMethodCalled(methodName));
        }
        return false;
    }

    public static boolean isPending(Method method) {
        if (method != null) {
            return method.getAnnotation(Pending.class) != null;
        }
        return false;
    }

    public static boolean isIgnored(Method method) {
        if (method != null) {
            return TestAnnotations.hasAnnotationCalled(method, "Ignore");
        }
        return false;
    }

    private static boolean hasAnnotationCalled(Method method, String annotationName) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = method.getAnnotations()) {
            if (!annotation.annotationType().getSimpleName().equals(annotationName)) continue;
            return true;
        }
        return false;
    }

    public boolean isIgnored(String methodName) {
        if (this.testClass != null) {
            return TestAnnotations.isIgnored(this.getMethodCalled(methodName));
        }
        return false;
    }

    private String getAnnotatedTitle(String methodName) {
        Method testMethod = this.getMethodCalled(methodName);
        Title titleAnnotation = testMethod.getAnnotation(Title.class);
        if (titleAnnotation != null) {
            return titleAnnotation.value();
        }
        return null;
    }

    private boolean testClassHasMethodCalled(String methodName) {
        return this.getMethodCalled(methodName) != null;
    }

    private Method getMethodCalled(String methodName) {
        String baseMethodName = NameConverter.withNoArguments(methodName);
        try {
            return this.testClass.getMethod(baseMethodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public List<String> getAnnotatedIssuesForMethodTitle(String methodName) {
        String title = this.getAnnotatedTitleForMethod(methodName);
        if (title != null) {
            return Formatter.issuesIn(title);
        }
        return Formatter.issuesIn(methodName);
    }

    private String getAnnotatedIssue(String methodName) {
        Method testMethod = this.getMethodCalled(methodName);
        if (testMethod != null && testMethod.getAnnotation(Issue.class) != null) {
            return testMethod.getAnnotation(Issue.class).value();
        }
        return null;
    }

    private String[] getAnnotatedIssues(String methodName) {
        Method testMethod = this.getMethodCalled(methodName);
        if (testMethod != null && testMethod.getAnnotation(Issues.class) != null) {
            return testMethod.getAnnotation(Issues.class).value();
        }
        return null;
    }

    public String getAnnotatedIssueForMethod(String methodName) {
        return this.getAnnotatedIssue(methodName);
    }

    public String[] getAnnotatedIssuesForMethod(String methodName) {
        return this.getAnnotatedIssues(methodName);
    }

    public String getAnnotatedIssueForTestCase(Class<?> testCase) {
        Issue issueAnnotation = testCase.getAnnotation(Issue.class);
        if (issueAnnotation != null) {
            return issueAnnotation.value();
        }
        return null;
    }

    public String[] getAnnotatedIssuesForTestCase(Class<?> testCase) {
        Issues issueAnnotation = testCase.getAnnotation(Issues.class);
        if (issueAnnotation != null) {
            return issueAnnotation.value();
        }
        return null;
    }

    public List<String> getIssuesForMethod(String methodName) {
        ArrayList<String> issues = new ArrayList<String>();
        if (this.testClass != null) {
            this.addIssuesFromMethod(methodName, issues);
        } else {
            this.addIssuesFromTestScenarioName(methodName, issues);
        }
        return issues;
    }

    private void addIssuesFromTestScenarioName(String methodName, List<String> issues) {
        issues.addAll(this.getAnnotatedIssuesForMethodTitle(methodName));
    }

    private void addIssuesFromMethod(String methodName, List<String> issues) {
        if (this.getAnnotatedIssues(methodName) != null) {
            issues.addAll(Arrays.asList(this.getAnnotatedIssues(methodName)));
        }
        if (this.getAnnotatedIssue(methodName) != null) {
            issues.add(this.getAnnotatedIssue(methodName));
        }
        if (this.getAnnotatedTitle(methodName) != null) {
            this.addIssuesFromTestScenarioName(methodName, issues);
        }
    }
}

