/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages;

import java.util.concurrent.TimeUnit;
import net.thucydides.core.pages.JavaScriptExecutorFacade;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Clock;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.Sleeper;
import org.openqa.selenium.support.ui.SystemClock;
import org.openqa.selenium.support.ui.Wait;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebElementFacade {
    private final WebElement webElement;
    private final WebDriver driver;
    private final long timeoutInMilliseconds;
    private static final int WAIT_FOR_ELEMENT_PAUSE_LENGTH = 250;
    private final Sleeper sleeper;
    private final Clock webdriverClock;
    private JavaScriptExecutorFacade javaScriptExecutorFacade;

    public WebElementFacade(WebDriver driver, WebElement webElement, long timeoutInMilliseconds) {
        this.driver = driver;
        this.webElement = webElement;
        this.timeoutInMilliseconds = timeoutInMilliseconds;
        this.webdriverClock = new SystemClock();
        this.sleeper = Sleeper.SYSTEM_SLEEPER;
        this.javaScriptExecutorFacade = new JavaScriptExecutorFacade(driver);
    }

    protected JavaScriptExecutorFacade getJavaScriptExecutorFacade() {
        return this.javaScriptExecutorFacade;
    }

    public boolean isVisible() {
        try {
            return this.webElement.isDisplayed();
        }
        catch (NoSuchElementException e) {
            return false;
        }
        catch (StaleElementReferenceException se) {
            return false;
        }
    }

    public WebElementFacade and() {
        return this;
    }

    public WebElementFacade then() {
        return this;
    }

    public boolean isCurrentlyVisible() {
        return this.isVisible();
    }

    public boolean isCurrentlyEnabled() {
        try {
            return this.webElement.isEnabled();
        }
        catch (NoSuchElementException e) {
            return false;
        }
        catch (StaleElementReferenceException se) {
            return false;
        }
    }

    public void shouldBeVisible() {
        if (!this.isVisible()) {
            throw new AssertionError((Object)"Element should be visible");
        }
    }

    public void shouldBeCurrentlyVisible() {
        if (!this.isCurrentlyVisible()) {
            throw new AssertionError((Object)"Element should be visible");
        }
    }

    public void shouldNotBeVisible() {
        if (this.isVisible()) {
            throw new AssertionError((Object)"Element should not be visible");
        }
    }

    public void shouldNotBeCurrentlyVisible() {
        if (this.isCurrentlyVisible()) {
            throw new AssertionError((Object)"Element should not be visible");
        }
    }

    public boolean hasFocus() {
        JavaScriptExecutorFacade js = new JavaScriptExecutorFacade(this.driver);
        WebElement activeElement = (WebElement)js.executeScript("return window.document.activeElement");
        return this.webElement.equals(activeElement);
    }

    public boolean containsText(String value) {
        return this.webElement.getText().contains(value);
    }

    public void shouldContainText(String textValue) {
        if (!this.containsText(textValue)) {
            String errorMessage = String.format("The text '%s' was not found in the web element", textValue);
            throw new AssertionError((Object)errorMessage);
        }
    }

    public void shouldNotContainText(String textValue) {
        if (this.containsText(textValue)) {
            String errorMessage = String.format("The text '%s' was not found in the web element", textValue);
            throw new AssertionError((Object)errorMessage);
        }
    }

    public void shouldBeEnabled() {
        if (!this.isEnabled()) {
            String errorMessage = String.format("Field '%s' should be enabled", this.webElement);
            throw new AssertionError((Object)errorMessage);
        }
    }

    public boolean isEnabled() {
        return this.webElement.isEnabled();
    }

    public void shouldNotBeEnabled() {
        if (this.isEnabled()) {
            String errorMessage = String.format("Field '%s' should not be enabled", this.webElement);
            throw new AssertionError((Object)errorMessage);
        }
    }

    public WebElementFacade type(String value) {
        this.waitUntilElementAvailable();
        this.webElement.clear();
        this.webElement.sendKeys(new CharSequence[]{value});
        return this;
    }

    public WebElementFacade typeAndEnter(String value) {
        this.waitUntilElementAvailable();
        this.webElement.clear();
        this.webElement.sendKeys(new CharSequence[]{value, Keys.ENTER});
        return this;
    }

    public WebElementFacade typeAndTab(String value) {
        this.waitUntilElementAvailable();
        this.webElement.clear();
        this.webElement.sendKeys(new CharSequence[]{value + Keys.TAB});
        return this;
    }

    public void setWindowFocus() {
        this.getJavaScriptExecutorFacade().executeScript("window.focus()");
    }

    public WebElementFacade selectByVisibleText(String label) {
        this.waitUntilElementAvailable();
        Select select = new Select(this.webElement);
        select.selectByVisibleText(label);
        return this;
    }

    public String getSelectedVisibleTextValue() {
        this.waitUntilVisible();
        Select select = new Select(this.webElement);
        return select.getFirstSelectedOption().getText();
    }

    public WebElementFacade selectByValue(String value) {
        this.waitUntilElementAvailable();
        Select select = new Select(this.webElement);
        select.selectByValue(value);
        return this;
    }

    public String getSelectedValue() {
        this.waitUntilVisible();
        Select select = new Select(this.webElement);
        return select.getFirstSelectedOption().getAttribute("value");
    }

    public WebElementFacade selectByIndex(int indexValue) {
        this.waitUntilElementAvailable();
        Select select = new Select(this.webElement);
        select.selectByIndex(indexValue);
        return this;
    }

    private void waitUntilElementAvailable() {
        this.waitUntilEnabled();
    }

    public boolean isPresent() {
        try {
            return this.webElement.isDisplayed() || !this.webElement.isDisplayed();
        }
        catch (NoSuchElementException e) {
            return e.getCause().getMessage().contains("Element is not usable");
        }
    }

    public void shouldBePresent() {
        if (!this.isPresent()) {
            String errorMessage = String.format("Field should be present", new Object[0]);
            throw new AssertionError((Object)errorMessage);
        }
    }

    public void shouldNotBePresent() {
        if (this.isPresent()) {
            String errorMessage = String.format("Field should not be present", new Object[0]);
            throw new AssertionError((Object)errorMessage);
        }
    }

    public WebElementFacade waitUntilVisible() {
        try {
            this.waitForCondition().until(this.elementIsDisplayed());
        }
        catch (TimeoutException timeout) {
            this.throwErrorWithCauseIfPresent(timeout, timeout.getMessage());
        }
        return this;
    }

    public WebElementFacade waitUntilPresent() {
        try {
            this.waitForCondition().until(this.elementIsPresent());
        }
        catch (TimeoutException timeout) {
            this.throwErrorWithCauseIfPresent(timeout, timeout.getMessage());
        }
        return this;
    }

    private void throwErrorWithCauseIfPresent(TimeoutException timeout, String defaultMessage) {
        String timeoutMessage = timeout.getCause() != null ? timeout.getCause().getMessage() : timeout.getMessage();
        throw new ElementNotVisibleException(timeoutMessage, (Throwable)timeout);
    }

    private ExpectedCondition<Boolean> elementIsDisplayed() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return WebElementFacade.this.webElement.isDisplayed();
            }
        };
    }

    private ExpectedCondition<Boolean> elementIsPresent() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return WebElementFacade.this.isPresent();
            }
        };
    }

    private ExpectedCondition<Boolean> elementIsNotDisplayed() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return !WebElementFacade.this.isCurrentlyVisible();
            }
        };
    }

    private ExpectedCondition<Boolean> elementIsEnabled() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return WebElementFacade.this.webElement.isEnabled();
            }
        };
    }

    private ExpectedCondition<Boolean> elementIsNotEnabled() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return !WebElementFacade.this.webElement.isEnabled();
            }
        };
    }

    public Wait<WebDriver> waitForCondition() {
        return new FluentWait((Object)this.driver, this.webdriverClock, this.sleeper).withTimeout(this.timeoutInMilliseconds, TimeUnit.MILLISECONDS).pollingEvery(250L, TimeUnit.MILLISECONDS).ignoring(NoSuchElementException.class, NoSuchFrameException.class);
    }

    public WebElementFacade waitUntilNotVisible() {
        try {
            this.waitForCondition().until(this.elementIsNotDisplayed());
        }
        catch (TimeoutException timeout) {
            this.throwErrorWithCauseIfPresent(timeout, "Expected hidden element was displayed");
        }
        return this;
    }

    public String getValue() {
        this.waitUntilVisible();
        return this.webElement.getAttribute("value");
    }

    public boolean isSelected() {
        this.waitUntilVisible();
        return this.webElement.isSelected();
    }

    public String getText() {
        this.waitUntilVisible();
        return this.webElement.getText();
    }

    public WebElementFacade waitUntilEnabled() {
        try {
            this.waitForCondition().until(this.elementIsEnabled());
            return this;
        }
        catch (TimeoutException timeout) {
            throw new ElementNotVisibleException("Expected enabled element was not enabled", (Throwable)timeout);
        }
    }

    public WebElementFacade waitUntilDisabled() {
        try {
            this.waitForCondition().until(this.elementIsNotEnabled());
            return this;
        }
        catch (TimeoutException timeout) {
            throw new ElementNotVisibleException("Expected disabled element was not enabled", (Throwable)timeout);
        }
    }

    public String getTextValue() {
        this.waitUntilPresent();
        if (!this.isVisible()) {
            return "";
        }
        if (!StringUtils.isEmpty((CharSequence)this.webElement.getText())) {
            return this.webElement.getText();
        }
        if (!StringUtils.isEmpty((CharSequence)this.getValue())) {
            return this.getValue();
        }
        return "";
    }

    public WebElementFacade click() {
        this.waitUntilElementAvailable();
        this.webElement.click();
        return this;
    }

    public void clear() {
        String currentValue = this.getTextValue();
        for (int i = 0; i < currentValue.length(); ++i) {
            this.webElement.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
        }
    }
}

