/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.json;

import java.awt.Color;
import net.thucydides.core.model.FeatureResults;
import net.thucydides.core.model.StoryTestResults;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.reports.json.ColorScheme;

public class RelativeSizeColorScheme
implements ColorScheme {
    private static final float RED_HUE = 0.0f;
    private static final float ORANGE_HUE = 0.083333336f;
    private static final float YELLOW_HUE = 0.16666667f;
    private static final float GREEN_HUE = 0.33333334f;
    private static final float proportionOfPassingTestsAsGreenHue = 0.33333334f;
    private static final float MAX_BRIGHTNESS = 1.0f;
    private static final float MINIMUM_SATURATION = 0.75f;

    public static String rgbFormatOf(Color color) {
        String redByte = RelativeSizeColorScheme.convertToByte(color.getRed());
        String greenByte = RelativeSizeColorScheme.convertToByte(color.getGreen());
        String blueByte = RelativeSizeColorScheme.convertToByte(color.getBlue());
        return "#" + redByte + greenByte + blueByte;
    }

    private static String convertToByte(int colorByte) {
        if (colorByte < 16) {
            return "0" + Integer.toHexString(colorByte);
        }
        return Integer.toHexString(colorByte);
    }

    public Color colorFor(FeatureResults feature) {
        return this.colorForResults(feature.getTotalTests(), feature.getFailingTests(), feature.getPassingTests(), feature.getPendingTests());
    }

    public Color colorFor(StoryTestResults storyResult) {
        return this.colorForResults(storyResult.getTotal(), storyResult.getFailureCount(), storyResult.getSuccessCount(), storyResult.getPendingCount());
    }

    private Color colorForResults(int totalTests, int failingTests, int passingTests, int pendingTests) {
        if (totalTests == 0) {
            return Color.BLACK;
        }
        return this.calculateColorFromTestCount(totalTests, failingTests, passingTests, pendingTests);
    }

    private Color calculateColorFromTestCount(int totalTests, int failingTests, int passingTests, int pendingTests) {
        float hue = 0.0f;
        hue = failingTests > 0 && passingTests > 0 ? this.weightedHue(this.calculateHueBetween(0.0f, 0.33333334f, 0.16666667f, passingTests, failingTests)) : (failingTests > 0 && pendingTests > 0 ? this.weightedHue(this.calculateHueBetween(0.0f, 0.16666667f, 0.083333336f, pendingTests, failingTests)) : (failingTests > 0 ? 0.0f : this.calculateHueBetween(0.16666667f, 0.33333334f, 0.16666667f, passingTests, pendingTests)));
        float saturation = this.inverseOf(this.pendingToTotalTests(pendingTests, totalTests), 0.75);
        float brightness = 1.0f;
        return new Color(Color.HSBtoRGB(hue, saturation, brightness));
    }

    private float calculateHueBetween(float startColor, float endColor, float zeroColor, int mainCount, int complementaryCount) {
        float totalCount = mainCount + complementaryCount;
        float deltaColor = endColor - startColor;
        return startColor + (float)mainCount / totalCount * deltaColor;
    }

    private float inverseOf(double pendingToTotalTests, double minimumValue) {
        return (float)(minimumValue + (1.0 - pendingToTotalTests) * (1.0 - minimumValue));
    }

    private double pendingToTotalTests(int pendingTests, int totalTests) {
        return (double)pendingTests * 1.0 / (double)totalTests;
    }

    private float weightedHue(float rawHue) {
        double rawValue = rawHue / 0.33333334f;
        double weightedValue = 0.0;
        weightedValue = rawValue < 0.5 ? rawValue * 2.0 / 3.0 : 0.3333333333333333 + (rawValue - 0.5) * 1.3333333333333333;
        return (float)weightedValue * 0.33333334f;
    }

    public Color colorFor(TestOutcome outcome) {
        switch (outcome.getResult()) {
            case SUCCESS: {
                return Color.GREEN;
            }
            case FAILURE: {
                return Color.RED;
            }
            case PENDING: {
                return Color.YELLOW;
            }
            case SKIPPED: {
                return Color.GRAY;
            }
            case IGNORED: {
                return Color.ORANGE;
            }
        }
        throw new IllegalArgumentException("Unsupported test outcome: " + (Object)((Object)outcome.getResult()));
    }

    public Color colorFor(TestStep step) {
        switch (step.getResult()) {
            case SUCCESS: {
                return Color.GREEN;
            }
            case FAILURE: {
                return Color.RED;
            }
            case PENDING: {
                return Color.YELLOW;
            }
            case SKIPPED: {
                return Color.GRAY;
            }
            case IGNORED: {
                return Color.ORANGE;
            }
        }
        throw new IllegalArgumentException("Unsupported test step result: " + (Object)((Object)step.getResult()));
    }
}

