/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.util;

import java.util.Properties;
import net.thucydides.core.util.EnvironmentVariables;

public class MockEnvironmentVariables
implements EnvironmentVariables {
    private Properties properties = new Properties();
    private Properties values = new Properties();

    public String getValue(String name) {
        return this.values.getProperty(name);
    }

    public String getValue(String name, String defaultValue) {
        return this.values.getProperty(name, defaultValue);
    }

    public Integer getIntegerValue(String name, Integer defaultValue) {
        return Integer.parseInt(this.properties.getProperty(name));
    }

    public Boolean getBooleanValue(String name, boolean defaultValue) {
        if (this.properties.getProperty(name) == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(this.properties.getProperty(name, "false"));
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public String getProperty(String name, String defaultValue) {
        return this.properties.getProperty(name, defaultValue);
    }

    public void setProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    public void setValue(String name, String value) {
        this.properties.setProperty(name, value);
    }
}

