/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import java.io.File;
import net.thucydides.core.ThucydidesSystemProperties;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.DisplayedElementLocatorFactory;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.UnsupportedDriverException;
import net.thucydides.core.webdriver.WebdriverInstanceFactory;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.ProfilesIni;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDriverFactory {
    private final WebdriverInstanceFactory webdriverInstanceFactory;
    private ProfilesIni allProfiles;
    private static final int DEFAULT_HEIGHT = 1000;
    private static final int DEFAULT_WIDTH = 800;
    private final EnvironmentVariables environmentVariables;

    public WebDriverFactory() {
        this(new WebdriverInstanceFactory(), (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    public WebDriverFactory(WebdriverInstanceFactory webdriverInstanceFactory) {
        this(webdriverInstanceFactory, (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    public WebDriverFactory(WebdriverInstanceFactory webdriverInstanceFactory, EnvironmentVariables environmentVariables) {
        this.webdriverInstanceFactory = webdriverInstanceFactory;
        this.environmentVariables = environmentVariables;
    }

    protected ProfilesIni getAllProfiles() {
        if (this.allProfiles == null) {
            this.allProfiles = new ProfilesIni();
        }
        return this.allProfiles;
    }

    public WebDriver newInstanceOf(SupportedWebDriver driverType) {
        if (driverType == null) {
            throw new IllegalArgumentException("Driver type cannot be null");
        }
        return this.newWebdriverInstance(driverType.getWebdriverClass());
    }

    public static Class<? extends WebDriver> getClassFor(SupportedWebDriver driverType) {
        return driverType.getWebdriverClass();
    }

    protected WebDriver newWebdriverInstance(Class<? extends WebDriver> driverClass) {
        try {
            WebDriver driver = this.isAFirefoxDriver(driverClass) ? this.webdriverInstanceFactory.newInstanceOf(driverClass, this.buildFirefoxProfile()) : this.webdriverInstanceFactory.newInstanceOf(driverClass);
            if (this.supportsScreenResizing(driver)) {
                this.redimensionBrowser(driver);
            }
            return driver;
        }
        catch (Exception cause) {
            throw new UnsupportedDriverException("Could not instantiate " + driverClass, cause);
        }
    }

    private boolean supportsScreenResizing(WebDriver driver) {
        return this.isAFirefoxDriver(driver.getClass()) || this.isAnInternetExplorerDriver(driver.getClass());
    }

    private void redimensionBrowser(WebDriver driver) {
        int height = ThucydidesSystemProperties.getProperties().getIntegerValue(ThucydidesSystemProperty.SNAPSHOT_HEIGHT, 1000);
        int width = ThucydidesSystemProperties.getProperties().getIntegerValue(ThucydidesSystemProperty.SNAPSHOT_WIDTH, 800);
        this.resizeBrowserTo((JavascriptExecutor)driver, height, width);
    }

    private void resizeBrowserTo(JavascriptExecutor driver, int height, int width) {
        String resizeWindow = "window.resizeTo(" + width + "," + height + ")";
        driver.executeScript(resizeWindow, new Object[0]);
    }

    private boolean isAFirefoxDriver(Class<? extends WebDriver> driverClass) {
        return FirefoxDriver.class.isAssignableFrom(driverClass);
    }

    private boolean isAnInternetExplorerDriver(Class<? extends WebDriver> driverClass) {
        return InternetExplorerDriver.class.isAssignableFrom(driverClass);
    }

    protected FirefoxProfile createNewFirefoxProfile() {
        return new FirefoxProfile();
    }

    protected FirefoxProfile useExistingFirefoxProfile(File profileDirectory) {
        return new FirefoxProfile(profileDirectory);
    }

    private FirefoxProfile buildFirefoxProfile() {
        String profileName = System.getProperty("webdriver.firefox.profile");
        FirefoxProfile profile = profileName == null ? this.createNewFirefoxProfile() : this.getProfileFrom(profileName);
        if (this.dontAssumeUntrustedCertificateIssuer()) {
            profile.setAssumeUntrustedCertificateIssuer(false);
        }
        return profile;
    }

    private FirefoxProfile getProfileFrom(String profileName) {
        FirefoxProfile profile = this.getAllProfiles().getProfile(profileName);
        if (profile == null) {
            profile = this.useExistingFirefoxProfile(new File(profileName));
        }
        return profile;
    }

    private boolean dontAssumeUntrustedCertificateIssuer() {
        return this.environmentVariables.getBooleanValue(ThucydidesSystemProperty.ASSUME_UNTRUSTED_CERTIFICATE_ISSUER.getPropertyName(), true) == false;
    }

    public static void initElementsWithAjaxSupport(Object pageObject, WebDriver driver) {
        Configuration configuration = (Configuration)Injectors.getInjector().getInstance(Configuration.class);
        DisplayedElementLocatorFactory finder = new DisplayedElementLocatorFactory(driver, configuration.getElementTimeout());
        PageFactory.initElements((ElementLocatorFactory)finder, (Object)pageObject);
    }

    public static void initElementsWithAjaxSupport(Object pageObject, WebDriver driver, int timeout) {
        DisplayedElementLocatorFactory finder = new DisplayedElementLocatorFactory(driver, timeout);
        PageFactory.initElements((ElementLocatorFactory)finder, (Object)pageObject);
    }
}

