/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.issues.IssueTracking;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Formatter {
    private static final String ISSUE_NUMBER_REGEXP = "#([A-Z][A-Z0-9-_]*)?-?\\d+";
    private static final Pattern issueNumberPattern = Pattern.compile("#([A-Z][A-Z0-9-_]*)?-?\\d+");
    private final String issueLinkFormat = "<a href=\"{0}\">{1}</a>";
    private final IssueTracking issueTracking;

    public Formatter() {
        this((IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class));
    }

    @Inject
    public Formatter(IssueTracking issueTracking) {
        this.issueTracking = issueTracking;
    }

    public static List<String> issuesIn(String value) {
        Matcher matcher = issueNumberPattern.matcher(value);
        ArrayList<String> issues = new ArrayList<String>();
        while (matcher.find()) {
            issues.add(matcher.group());
        }
        return issues;
    }

    public String addLinks(String value) {
        String formattedValue = value;
        String issueUrlFormat = this.issueTracking.getIssueTrackerUrl();
        if (issueUrlFormat != null) {
            formattedValue = this.insertIssueTrackingUrls(value);
        }
        return formattedValue;
    }

    private String insertIssueTrackingUrls(String value) {
        String formattedValue = value;
        String issueUrlFormat = this.issueTracking.getIssueTrackerUrl();
        List<String> issues = Formatter.issuesIn(value);
        for (String issue : issues) {
            String issueUrl = MessageFormat.format(issueUrlFormat, this.stripLeadingHashFrom(issue));
            String issueLink = MessageFormat.format("<a href=\"{0}\">{1}</a>", issueUrl, issue);
            formattedValue = formattedValue.replaceAll(issue, issueLink);
        }
        return formattedValue;
    }

    private String stripLeadingHashFrom(String issue) {
        return issue.substring(1);
    }
}

