/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.google.inject.Inject;
import java.io.File;
import java.util.Locale;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.UnsupportedDriverException;

public class SystemPropertiesConfiguration
implements Configuration {
    public static final String WEBDRIVER_DRIVER = ThucydidesSystemProperty.DRIVER.getPropertyName();
    public static final String DEFAULT_WEBDRIVER_DRIVER = "firefox";
    public static final int DEFAULT_ELEMENT_TIMEOUT_SECONDS = 5;
    public final Integer DEFAULT_ESTIMATED_AVERAGE_STEP_COUNT = 5;
    public static final String OUTPUT_DIRECTORY_PROPERTY = ThucydidesSystemProperty.OUTPUT_DIRECTORY.getPropertyName();
    public static final String ASSUME_UNTRUSTED_CERTIFICATE_ISSUER = ThucydidesSystemProperty.ASSUME_UNTRUSTED_CERTIFICATE_ISSUER.getPropertyName();
    private static final String DEFAULT_OUTPUT_DIRECTORY = "target/site/thucydides";
    private File outputDirectory;
    private EnvironmentVariables environmentVariables;

    @Inject
    public SystemPropertiesConfiguration(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    protected EnvironmentVariables getEnvironmentVariables() {
        if (this.environmentVariables == null) {
            this.environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
        }
        return this.environmentVariables;
    }

    public SupportedWebDriver getDriverType() {
        String driverType = this.getEnvironmentVariables().getProperty(WEBDRIVER_DRIVER, DEFAULT_WEBDRIVER_DRIVER);
        return this.lookupSupportedDriverTypeFor(driverType);
    }

    public File loadOutputDirectoryFromSystemProperties() {
        String systemDefinedDirectory = this.getEnvironmentVariables().getProperty(OUTPUT_DIRECTORY_PROPERTY);
        if (systemDefinedDirectory == null) {
            systemDefinedDirectory = DEFAULT_OUTPUT_DIRECTORY;
        }
        return new File(systemDefinedDirectory);
    }

    public int getStepDelay() {
        int stepDelay = 0;
        String stepDelayValue = this.getEnvironmentVariables().getProperty(ThucydidesSystemProperty.STEP_DELAY.getPropertyName());
        if (stepDelayValue != null && !stepDelayValue.isEmpty()) {
            stepDelay = Integer.valueOf(stepDelayValue);
        }
        return stepDelay;
    }

    public int getElementTimeout() {
        int elementTimeout = 5;
        String stepDelayValue = this.getEnvironmentVariables().getProperty(ThucydidesSystemProperty.ELEMENT_TIMEOUT.getPropertyName());
        if (stepDelayValue != null && !stepDelayValue.isEmpty()) {
            elementTimeout = Integer.valueOf(stepDelayValue);
        }
        return elementTimeout;
    }

    public boolean getUseUniqueBrowser() {
        boolean uniqueBrowser = false;
        String uniqueBrowserValue = this.getEnvironmentVariables().getProperty(ThucydidesSystemProperty.UNIQUE_BROWSER.getPropertyName());
        if (uniqueBrowserValue != null) {
            uniqueBrowser = Boolean.valueOf(uniqueBrowserValue);
        }
        return uniqueBrowser;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public File getOutputDirectory() {
        this.outputDirectory = this.loadOutputDirectoryFromSystemProperties();
        this.outputDirectory.mkdirs();
        return this.outputDirectory;
    }

    public double getEstimatedAverageStepCount() {
        return this.getEnvironmentVariables().getIntegerValue(ThucydidesSystemProperty.ESTIMATED_AVERAGE_STEP_COUNT.getPropertyName(), this.DEFAULT_ESTIMATED_AVERAGE_STEP_COUNT).intValue();
    }

    public boolean onlySaveFailingScreenshots() {
        return this.getEnvironmentVariables().getBooleanValue(ThucydidesSystemProperty.ONLY_SAVE_FAILING_SCREENSHOTS.getPropertyName(), false);
    }

    private SupportedWebDriver lookupSupportedDriverTypeFor(String driverType) {
        SupportedWebDriver driver = null;
        try {
            driver = SupportedWebDriver.valueOf(driverType.toUpperCase(Locale.getDefault()));
        }
        catch (IllegalArgumentException iae) {
            this.throwUnsupportedDriverExceptionFor(driverType);
        }
        return driver;
    }

    private void throwUnsupportedDriverExceptionFor(String driverType) {
        throw new UnsupportedDriverException(driverType + " is not a supported browser. Supported driver values are: " + SupportedWebDriver.listOfSupportedDrivers());
    }
}

