/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.thucydides.core.annotations.WhenPageOpens;
import net.thucydides.core.pages.InternalSystemClock;
import net.thucydides.core.pages.JavaScriptExecutorFacade;
import net.thucydides.core.pages.MatchingPageExpressions;
import net.thucydides.core.pages.PageUrls;
import net.thucydides.core.pages.RenderedPageObjectView;
import net.thucydides.core.pages.UnableToInvokeWhenPageOpensMethods;
import net.thucydides.core.pages.WebElementFacade;
import net.thucydides.core.pages.components.Dropdown;
import net.thucydides.core.pages.components.FileToUpload;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webelements.Checkbox;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Clock;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Sleeper;
import org.openqa.selenium.support.ui.SystemClock;
import org.openqa.selenium.support.ui.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PageObject {
    private static final int WAIT_FOR_ELEMENT_PAUSE_LENGTH = 5;
    private static final int ONE_SECOND = 1000;
    private long waitForTimeout = 5000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PageObject.class);
    private static final long WAIT_FOR_TIMEOUT = 30000L;
    private WebDriver driver;
    private MatchingPageExpressions matchingPageExpressions;
    private RenderedPageObjectView renderedView;
    private PageUrls pageUrls;
    private InternalSystemClock clock = new InternalSystemClock();
    private final Sleeper sleeper;
    private final Clock webdriverClock;

    public PageObject(WebDriver driver, int ajaxTimeout) {
        this.driver = driver;
        this.waitForTimeout = ajaxTimeout;
        this.webdriverClock = new SystemClock();
        this.sleeper = Sleeper.SYSTEM_SLEEPER;
        this.setupPageUrls();
        WebDriverFactory.initElementsWithAjaxSupport(this, driver, ajaxTimeout);
    }

    public PageObject(WebDriver driver) {
        this.driver = driver;
        this.waitForTimeout = 30000L;
        this.webdriverClock = new SystemClock();
        this.sleeper = Sleeper.SYSTEM_SLEEPER;
        this.setupPageUrls();
        WebDriverFactory.initElementsWithAjaxSupport(this, driver);
    }

    public FileToUpload upload(String filename) {
        return new FileToUpload(filename);
    }

    private void setupPageUrls() {
        this.setPageUrls(new PageUrls(this));
    }

    public void setPageUrls(PageUrls pageUrls) {
        this.pageUrls = pageUrls;
    }

    public void setWaitForTimeout(long waitForTimeout) {
        this.waitForTimeout = waitForTimeout;
        this.getRenderedView().setWaitForTimeout(waitForTimeout);
    }

    protected RenderedPageObjectView getRenderedView() {
        if (this.renderedView == null) {
            this.renderedView = new RenderedPageObjectView(this.driver, this.waitForTimeout);
        }
        return this.renderedView;
    }

    protected InternalSystemClock getClock() {
        return this.clock;
    }

    private MatchingPageExpressions getMatchingPageExpressions() {
        if (this.matchingPageExpressions == null) {
            this.matchingPageExpressions = new MatchingPageExpressions(this);
        }
        return this.matchingPageExpressions;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public String getTitle() {
        return this.driver.getTitle();
    }

    protected boolean matchesAnyUrl() {
        return this.thereAreNoPatternsDefined();
    }

    public final boolean compatibleWithUrl(String currentUrl) {
        if (this.thereAreNoPatternsDefined()) {
            return true;
        }
        return this.matchUrlAgainstEachPattern(currentUrl);
    }

    private boolean matchUrlAgainstEachPattern(String currentUrl) {
        return this.getMatchingPageExpressions().matchUrlAgainstEachPattern(currentUrl);
    }

    private boolean thereAreNoPatternsDefined() {
        return this.getMatchingPageExpressions().isEmpty();
    }

    public PageObject waitForRenderedElements(By byElementCriteria) {
        this.getRenderedView().waitFor(byElementCriteria);
        return this;
    }

    public PageObject waitForRenderedElementsToBePresent(By byElementCriteria) {
        this.getRenderedView().waitForPresenceOf(byElementCriteria);
        return this;
    }

    public PageObject waitForRenderedElementsToDisappear(By byElementCriteria) {
        this.getRenderedView().waitForElementsToDisappear(byElementCriteria);
        return this;
    }

    public PageObject waitForTextToAppear(String expectedText) {
        this.getRenderedView().waitForText(expectedText);
        return this;
    }

    public PageObject waitForTitleToAppear(String expectedTitle) {
        this.getRenderedView().waitForTitle(expectedTitle);
        return this;
    }

    public PageObject waitForTitleToDisappear(String expectedTitle) {
        this.getRenderedView().waitForTitleToDisappear(expectedTitle);
        return this;
    }

    public PageObject waitForTextToAppear(WebElement element, String expectedText) {
        this.getRenderedView().waitForText(element, expectedText);
        return this;
    }

    public PageObject waitForTextToDisappear(WebElement element, String expectedText) {
        this.getRenderedView().waitForText(element, expectedText);
        return this;
    }

    public PageObject waitForTextToDisappear(String expectedText) {
        return this.waitForTextToDisappear(expectedText, this.waitForTimeout);
    }

    public PageObject waitForTextToDisappear(String expectedText, long timeout) {
        this.getRenderedView().waitForTextToDisappear(expectedText, timeout);
        return this;
    }

    public PageObject waitForAnyTextToAppear(String ... expectedText) {
        this.getRenderedView().waitForAnyTextToAppear(expectedText);
        return this;
    }

    public PageObject waitForAnyTextToAppear(WebElement element, String ... expectedText) {
        this.getRenderedView().waitForAnyTextToAppear(element, expectedText);
        return this;
    }

    public PageObject waitForAllTextToAppear(String ... expectedTexts) {
        this.getRenderedView().waitForAllTextToAppear(expectedTexts);
        return this;
    }

    public PageObject waitForAnyRenderedElementOf(By ... expectedElements) {
        this.getRenderedView().waitForAnyRenderedElementOf(expectedElements);
        return this;
    }

    protected void waitABit(long timeInMilliseconds) {
        this.getClock().pauseFor(timeInMilliseconds);
    }

    public List<WebElement> thenReturnElementList(By byListCriteria) {
        return this.driver.findElements(byListCriteria);
    }

    public void shouldContainText(String textValue) {
        if (!this.containsText(textValue)) {
            String errorMessage = String.format("The text '%s' was not found in the page", textValue);
            throw new NoSuchElementException(errorMessage);
        }
    }

    public void shouldContainAllText(String ... textValues) {
        if (!this.containsAllText(textValues)) {
            String errorMessage = String.format("One of the text elements in '%s' was not found in the page", textValues);
            throw new NoSuchElementException(errorMessage);
        }
    }

    @Deprecated
    public boolean containsTextInElement(WebElement webElement, String textValue) {
        return this.element(webElement).containsText(textValue);
    }

    @Deprecated
    public void shouldContainTextInElement(WebElement webElement, String textValue) {
        this.element(webElement).shouldContainText(textValue);
    }

    @Deprecated
    public void shouldNotContainTextInElement(WebElement webElement, String textValue) {
        this.element(webElement).shouldNotContainText(textValue);
    }

    public void typeInto(WebElement field, String value) {
        field.clear();
        field.sendKeys(new CharSequence[]{value});
    }

    public FieldEntry enter(String value) {
        return new FieldEntry(value);
    }

    public void selectFromDropdown(WebElement dropdown, String visibleLabel) {
        Dropdown.forWebElement(dropdown).select(visibleLabel);
    }

    public void selectMultipleItemsFromDropdown(WebElement dropdown, String ... selectedLabels) {
        Dropdown.forWebElement(dropdown).selectMultipleItems(selectedLabels);
    }

    public Set<String> getSelectedOptionLabelsFrom(WebElement dropdown) {
        return Dropdown.forWebElement(dropdown).getSelectedOptionLabels();
    }

    public Set<String> getSelectedOptionValuesFrom(WebElement dropdown) {
        return Dropdown.forWebElement(dropdown).getSelectedOptionValues();
    }

    public String getSelectedValueFrom(WebElement dropdown) {
        return Dropdown.forWebElement(dropdown).getSelectedValue();
    }

    public String getSelectedLabelFrom(WebElement dropdown) {
        return Dropdown.forWebElement(dropdown).getSelectedLabel();
    }

    public void setCheckbox(WebElement field, boolean value) {
        Checkbox checkbox = new Checkbox(field);
        checkbox.setChecked(value);
    }

    public boolean containsText(String textValue) {
        return this.getRenderedView().containsText(textValue);
    }

    public boolean containsAllText(String ... textValues) {
        for (String textValue : textValues) {
            if (this.getRenderedView().containsText(textValue)) continue;
            return false;
        }
        return true;
    }

    public void shouldBeVisible(WebElement field) {
        this.element(field).shouldBeVisible();
    }

    public void shouldBeVisible(By byCriteria) {
        WebElement element = this.getDriver().findElement(byCriteria);
        this.shouldBeVisible(element);
    }

    public void shouldNotBeVisible(WebElement field) {
        this.element(field).shouldNotBeVisible();
    }

    public void shouldNotBeVisible(By byCriteria) {
        WebElement element = this.getDriver().findElement(byCriteria);
        this.shouldNotBeVisible(element);
    }

    public String updateUrlWithBaseUrlIfDefined(String startingUrl) {
        String baseUrl = this.pageUrls.getBaseUrl();
        if (baseUrl != null && !StringUtils.isEmpty((CharSequence)baseUrl)) {
            return this.replaceHost(startingUrl, baseUrl);
        }
        return startingUrl;
    }

    private String replaceHost(String starting, String base) {
        String updatedUrl = starting;
        try {
            URL startingUrl = new URL(starting);
            URL baseUrl = new URL(base);
            String startingHostComponent = this.hostComponentFrom(startingUrl.getProtocol(), startingUrl.getHost(), startingUrl.getPort());
            String baseHostComponent = this.hostComponentFrom(baseUrl.getProtocol(), baseUrl.getHost(), baseUrl.getPort());
            updatedUrl = starting.replaceFirst(startingHostComponent, baseHostComponent);
        }
        catch (MalformedURLException e) {
            LOGGER.error("Failed to analyse default page URL: Starting URL: {}, Base URL: {}", (Object)starting, (Object)base);
            LOGGER.error("URL analysis failed with exception:", (Throwable)e);
        }
        return updatedUrl;
    }

    private String hostComponentFrom(String protocol, String host, int port) {
        StringBuffer hostComponent = new StringBuffer(protocol);
        hostComponent.append("://");
        hostComponent.append(host);
        if (port > 0) {
            hostComponent.append(":");
            hostComponent.append(port);
        }
        return hostComponent.toString();
    }

    public final void open(String ... parameterValues) {
        String startingUrl = this.pageUrls.getStartingUrl(parameterValues);
        LOGGER.debug("Opening page at url {}", (Object)startingUrl);
        this.openPageAtUrl(startingUrl);
        this.callWhenPageOpensMethods();
        LOGGER.debug("Page opened");
    }

    public final void open(String urlTemplateName, String[] parameterValues) {
        String startingUrl = this.pageUrls.getNamedUrl(urlTemplateName, parameterValues);
        LOGGER.debug("Opening page at url {}", (Object)startingUrl);
        this.openPageAtUrl(startingUrl);
        this.callWhenPageOpensMethods();
        LOGGER.debug("Page opened");
    }

    public final void open() {
        String startingUrl = this.updateUrlWithBaseUrlIfDefined(this.pageUrls.getStartingUrl());
        this.openPageAtUrl(startingUrl);
        this.callWhenPageOpensMethods();
    }

    public void callWhenPageOpensMethods() {
        for (Method annotatedMethod : this.methodsAnnotatedWithWhenPageOpens()) {
            try {
                annotatedMethod.setAccessible(true);
                annotatedMethod.invoke((Object)this, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("Could not execute @WhenPageOpens annotated method: " + e.getMessage());
                throw new UnableToInvokeWhenPageOpensMethods("Could not execute @WhenPageOpens annotated method: " + e.getMessage(), e);
            }
        }
    }

    private List<Method> methodsAnnotatedWithWhenPageOpens() {
        Method[] methods = this.getClass().getDeclaredMethods();
        ArrayList<Method> annotatedMethods = new ArrayList<Method>();
        for (Method method : methods) {
            if (method.getAnnotation(WhenPageOpens.class) == null) continue;
            if (method.getParameterTypes().length == 0) {
                annotatedMethods.add(method);
                continue;
            }
            throw new UnableToInvokeWhenPageOpensMethods("Could not execute @WhenPageOpens annotated method: WhenPageOpens method cannot have parameters: " + method);
        }
        return annotatedMethods;
    }

    public static String[] withParameters(String ... parameterValues) {
        return parameterValues;
    }

    private void openPageAtUrl(String startingUrl) {
        this.getDriver().get(startingUrl);
    }

    public void clickOn(WebElement webElement) {
        webElement.click();
    }

    public Boolean isElementVisible(By byCriteria) {
        return this.getRenderedView().elementIsDisplayed(byCriteria);
    }

    public void setDefaultBaseUrl(String defaultBaseUrl) {
        this.pageUrls.overrideDefaultBaseUrl(defaultBaseUrl);
    }

    public boolean hasFocus(WebElement webElement) {
        return this.element(webElement).hasFocus();
    }

    public WebElementFacade element(WebElement webElement) {
        return new WebElementFacade(this.driver, webElement, this.waitForTimeout);
    }

    public Object evaluateJavascript(String script) {
        JavaScriptExecutorFacade js = new JavaScriptExecutorFacade(this.driver);
        return js.executeScript(script);
    }

    public Wait<WebDriver> waitForCondition() {
        return new FluentWait((Object)this.driver, this.webdriverClock, this.sleeper).withTimeout(this.waitForTimeout, TimeUnit.SECONDS).pollingEvery(5L, TimeUnit.MILLISECONDS).ignoring(NoSuchElementException.class, NoSuchFrameException.class);
    }

    public class FieldEntry {
        private final String value;

        public FieldEntry(String value) {
            this.value = value;
        }

        public void into(WebElement field) {
            field.clear();
            field.sendKeys(new CharSequence[]{this.value});
        }

        public void intoField(By bySelector) {
            WebElement field = PageObject.this.getDriver().findElement(bySelector);
            field.clear();
            field.sendKeys(new CharSequence[]{this.value});
        }
    }
}

