/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import java.util.List;
import java.util.Set;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.webdriver.UnsupportedDriverException;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDriverFacade
implements WebDriver,
TakesScreenshot {
    private final Class<? extends WebDriver> driverClass;
    private final WebDriverFactory webDriverFactory;
    protected WebDriver proxiedWebDriver;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDriverFacade.class);

    public WebDriverFacade(Class<? extends WebDriver> driverClass, WebDriverFactory webDriverFactory) {
        this.driverClass = driverClass;
        this.webDriverFactory = webDriverFactory;
    }

    public WebDriver getProxiedDriver() {
        if (this.proxiedWebDriver == null) {
            this.proxiedWebDriver = this.newProxyDriver();
            WebdriverProxyFactory.getFactory().notifyListenersOfWebdriverCreationIn(this);
        }
        this.ensureValidDriver();
        return this.proxiedWebDriver;
    }

    private boolean isEnabled() {
        return !StepEventBus.getEventBus().webdriverCallsAreSuspended();
    }

    private void ensureValidDriver() {
        try {
            this.proxiedWebDriver.getCurrentUrl();
        }
        catch (WebDriverException e) {
            this.proxiedWebDriver.switchTo().defaultContent();
        }
    }

    public void reset() {
        if (this.proxiedWebDriver != null) {
            this.forcedQuit();
        }
        this.proxiedWebDriver = null;
    }

    private void forcedQuit() {
        try {
            this.getDriverInstance().quit();
            this.proxiedWebDriver = null;
        }
        catch (WebDriverException e) {
            LOGGER.warn("Closing a driver that was already closed", (Throwable)e);
        }
    }

    protected WebDriver newProxyDriver() {
        return this.newDriverInstance();
    }

    private WebDriver newDriverInstance() {
        try {
            return this.webDriverFactory.newWebdriverInstance(this.driverClass);
        }
        catch (Exception e) {
            throw new UnsupportedDriverException("Could not instantiate " + this.driverClass, e);
        }
    }

    public <X> X getScreenshotAs(OutputType<X> target) {
        if (this.proxyInstanciated() && this.driverCanTakeScreenshots()) {
            try {
                return (X)((TakesScreenshot)this.getProxiedDriver()).getScreenshotAs(target);
            }
            catch (WebDriverException e) {
                LOGGER.warn("Failed to take screenshot - driver closed already?", (Throwable)e);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                LOGGER.error("Failed to take screenshot - out of memory", (Throwable)outOfMemoryError);
            }
        }
        return null;
    }

    private boolean driverCanTakeScreenshots() {
        return TakesScreenshot.class.isAssignableFrom(this.getProxiedDriver().getClass());
    }

    public void get(String url) {
        if (!this.isEnabled()) {
            return;
        }
        this.getProxiedDriver().get(url);
    }

    public String getCurrentUrl() {
        if (!this.isEnabled()) {
            return null;
        }
        return this.getProxiedDriver().getCurrentUrl();
    }

    public String getTitle() {
        if (!this.isEnabled()) {
            return null;
        }
        return this.getProxiedDriver().getTitle();
    }

    public List<WebElement> findElements(By by) {
        if (!this.isEnabled()) {
            return null;
        }
        return this.getProxiedDriver().findElements(by);
    }

    public WebElement findElement(By by) {
        if (!this.isEnabled()) {
            return null;
        }
        return this.getProxiedDriver().findElement(by);
    }

    public String getPageSource() {
        if (!this.isEnabled()) {
            return null;
        }
        return this.getProxiedDriver().getPageSource();
    }

    protected WebDriver getDriverInstance() {
        return this.proxiedWebDriver;
    }

    public void close() {
        if (this.proxyInstanciated()) {
            this.getDriverInstance().close();
        }
    }

    public void quit() {
        if (this.proxyInstanciated()) {
            try {
                this.getDriverInstance().quit();
            }
            catch (WebDriverException e) {
                LOGGER.warn("Error while quitting the driver - is this IE?");
            }
            this.proxiedWebDriver = null;
        }
    }

    protected boolean proxyInstanciated() {
        return this.getDriverInstance() != null;
    }

    public Set<String> getWindowHandles() {
        if (!this.isEnabled()) {
            return null;
        }
        return this.getProxiedDriver().getWindowHandles();
    }

    public String getWindowHandle() {
        if (!this.isEnabled()) {
            return null;
        }
        return this.getProxiedDriver().getWindowHandle();
    }

    public WebDriver.TargetLocator switchTo() {
        if (!this.isEnabled()) {
            return null;
        }
        return this.getProxiedDriver().switchTo();
    }

    public WebDriver.Navigation navigate() {
        if (!this.isEnabled()) {
            return null;
        }
        return this.getProxiedDriver().navigate();
    }

    public WebDriver.Options manage() {
        if (!this.isEnabled()) {
            return null;
        }
        return this.getProxiedDriver().manage();
    }

    public boolean canTakeScreenshots() {
        return this.driverClass != null && TakesScreenshot.class.isAssignableFrom(this.driverClass);
    }
}

