/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages.scheduling;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.thucydides.core.pages.scheduling.PollingSchedule;
import net.thucydides.core.pages.scheduling.TimeoutSchedule;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.support.ui.Clock;
import org.openqa.selenium.support.ui.Duration;
import org.openqa.selenium.support.ui.Sleeper;
import org.openqa.selenium.support.ui.Wait;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ThucydidesFluentWait<T>
implements Wait<T> {
    public static Duration FIVE_HUNDRED_MILLIS = new Duration(500L, TimeUnit.MILLISECONDS);
    protected Duration timeout = FIVE_HUNDRED_MILLIS;
    protected Duration interval = FIVE_HUNDRED_MILLIS;
    private List<Class<? extends RuntimeException>> ignoredExceptions = Lists.newLinkedList();
    private final Clock clock;
    private final T input;
    private final Sleeper sleeper;

    public ThucydidesFluentWait(T input, Clock clock, Sleeper sleeper) {
        this.input = Preconditions.checkNotNull(input);
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
        this.sleeper = (Sleeper)Preconditions.checkNotNull((Object)sleeper);
    }

    protected Clock getClock() {
        return this.clock;
    }

    protected T getInput() {
        return this.input;
    }

    protected Sleeper getSleeper() {
        return this.sleeper;
    }

    public <V> V until(Function<? super T, V> isTrue) {
        long end = this.clock.laterBy(this.timeout.in(TimeUnit.MILLISECONDS));
        RuntimeException lastException = null;
        while (true) {
            try {
                Object value = isTrue.apply(this.input);
                if (value != null && Boolean.class.equals(value.getClass()) ? Boolean.TRUE.equals(value) : value != null) {
                    return (V)value;
                }
            }
            catch (RuntimeException e) {
                lastException = this.propagateIfNotIngored(e);
            }
            if (!this.clock.isNowBefore(end)) {
                throw this.timeoutException(String.format("Timed out after %d seconds", this.timeout.in(TimeUnit.SECONDS)), lastException);
            }
            try {
                this.doWait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WebDriverException((Throwable)e);
            }
        }
    }

    public abstract void doWait() throws InterruptedException;

    private RuntimeException propagateIfNotIngored(RuntimeException e) {
        for (Class<? extends RuntimeException> ignoredException : this.ignoredExceptions) {
            if (!ignoredException.isInstance(e)) continue;
            return e;
        }
        throw e;
    }

    public ThucydidesFluentWait<T> ignoring(Class<? extends RuntimeException> ... types) {
        this.ignoredExceptions.addAll(Arrays.asList(types));
        return this;
    }

    public ThucydidesFluentWait<T> withTimeout(long duration, TimeUnit unit) {
        this.timeout = new Duration(duration, unit);
        return this;
    }

    public ThucydidesFluentWait<T> pollingEvery(long duration, TimeUnit unit) {
        this.interval = new Duration(duration, unit);
        return this;
    }

    protected RuntimeException timeoutException(String message, RuntimeException lastException) {
        throw new TimeoutException(message, (Throwable)lastException);
    }

    public TimeoutSchedule withTimeoutOf(int amount) {
        return new TimeoutSchedule(this, amount);
    }

    public PollingSchedule pollingEvery(int amount) {
        return new PollingSchedule(this, amount);
    }
}

