/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.images;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.thucydides.core.images.ResizedImage;
import net.thucydides.core.images.SimpleImageInfo;
import org.apache.commons.io.FileUtils;

public class ResizableImage {
    private final File screenshotFile;
    private final SimpleImageInfo imageInfo;
    private final int MAX_SUPPORTED_HEIGHT = 1200;

    public ResizableImage(File screenshotFile) throws IOException {
        this.screenshotFile = screenshotFile;
        this.imageInfo = new SimpleImageInfo(screenshotFile);
    }

    public static ResizableImage loadFrom(File screenshotFile) throws IOException {
        return new ResizableImage(screenshotFile);
    }

    public int getWitdh() {
        return this.imageInfo.getWidth();
    }

    public int getHeight() {
        return this.imageInfo.getHeight();
    }

    public ResizableImage rescaleCanvas(int width, int height) throws IOException {
        if (this.getHeight() > height) {
            return this;
        }
        if (this.getHeight() > 1200) {
            return this;
        }
        BufferedImage image = ImageIO.read(this.screenshotFile);
        BufferedImage resizedImage = new BufferedImage(width, height, 3);
        this.fillWithWhiteBackground(resizedImage);
        resizedImage.setData(image.getRaster());
        return new ResizedImage(resizedImage, this.screenshotFile);
    }

    private void fillWithWhiteBackground(BufferedImage resizedImage) {
        Graphics2D g2d = resizedImage.createGraphics();
        g2d.setColor(Color.LIGHT_GRAY);
        g2d.fill(new Rectangle2D.Float(0.0f, 0.0f, resizedImage.getWidth(), resizedImage.getHeight()));
        g2d.dispose();
    }

    public void saveTo(File savedFile) throws IOException {
        FileUtils.copyFile((File)this.screenshotFile, (File)savedFile);
    }
}

