/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.ReportGenerationFailedError;
import sun.misc.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportService {
    private File outputDirectory;
    private List<AcceptanceTestReporter> subscribedReporters;

    public ReportService(File outputDirectory, Collection<AcceptanceTestReporter> subscribedReporters) {
        this.outputDirectory = outputDirectory;
        this.getSubscribedReporters().addAll(subscribedReporters);
    }

    public List<AcceptanceTestReporter> getSubscribedReporters() {
        if (this.subscribedReporters == null) {
            this.subscribedReporters = new ArrayList<AcceptanceTestReporter>();
        }
        return this.subscribedReporters;
    }

    public void subscribe(AcceptanceTestReporter reporter) {
        this.getSubscribedReporters().add(reporter);
    }

    public void useQualifier(String qualifier) {
        for (AcceptanceTestReporter reporter : this.getSubscribedReporters()) {
            reporter.setQualifier(qualifier);
        }
    }

    public void generateReportsFor(List<TestOutcome> testOutcomeResults) {
        for (AcceptanceTestReporter reporter : this.getSubscribedReporters()) {
            for (TestOutcome testOutcomeResult : testOutcomeResults) {
                this.generateReportFor(testOutcomeResult, reporter);
            }
        }
    }

    public static List<AcceptanceTestReporter> getDefaultReporters() {
        ArrayList<AcceptanceTestReporter> reporters = new ArrayList<AcceptanceTestReporter>();
        Iterator reporterImplementations = Service.providers(AcceptanceTestReporter.class);
        while (reporterImplementations.hasNext()) {
            reporters.add((AcceptanceTestReporter)reporterImplementations.next());
        }
        return reporters;
    }

    private void generateReportFor(TestOutcome testOutcome, AcceptanceTestReporter reporter) {
        try {
            reporter.setOutputDirectory(this.outputDirectory);
            reporter.generateReportFor(testOutcome);
        }
        catch (IOException e) {
            throw new ReportGenerationFailedError("Failed to generate reports using " + reporter, e);
        }
    }
}

