/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.google.inject.Inject;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.WebdriverManager;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThucydidesWebdriverManager
implements WebdriverManager {
    private static final ThreadLocal<WebDriver> webdriverThreadLocal = new ThreadLocal();
    private final WebDriverFactory webDriverFactory;
    private final Configuration configuration;
    private static final Logger LOGGER = LoggerFactory.getLogger(ThucydidesWebdriverManager.class);

    @Inject
    public ThucydidesWebdriverManager(WebDriverFactory webDriverFactory, Configuration configuration) {
        this.webDriverFactory = webDriverFactory;
        this.configuration = configuration;
    }

    private static WebDriver newDriver(Configuration configuration, WebDriverFactory webDriverFactory) {
        SupportedWebDriver supportedDriverType = configuration.getDriverType();
        Class<? extends WebDriver> webDriverType = WebDriverFactory.getClassFor(supportedDriverType);
        return WebdriverProxyFactory.getFactory().proxyFor(webDriverType, webDriverFactory);
    }

    public void closeDriver() {
        if (this.getWebdriver() != null) {
            LOGGER.debug("Closing driver instance for thread");
            this.getWebdriver().close();
            this.getWebdriver().quit();
            webdriverThreadLocal.remove();
        }
    }

    public WebDriver getWebdriver() {
        return ThucydidesWebdriverManager.getThreadLocalWebDriver(this.configuration, this.webDriverFactory);
    }

    private static WebDriver getThreadLocalWebDriver(Configuration configuration, WebDriverFactory webDriverFactory) {
        if (webdriverThreadLocal.get() == null) {
            LOGGER.debug("Instanciating new driver instance for thread");
            webdriverThreadLocal.set(ThucydidesWebdriverManager.newDriver(configuration, webDriverFactory));
        }
        return webdriverThreadLocal.get();
    }
}

