/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.util.List;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.pages.PagesAnnotatedField;
import net.thucydides.core.steps.ScenarioSteps;
import net.thucydides.core.steps.StepFactory;
import net.thucydides.core.steps.StepsAnnotatedField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StepAnnotations {
    private StepAnnotations() {
    }

    public static void injectScenarioStepsInto(Object testCase, StepFactory stepFactory) {
        List<StepsAnnotatedField> stepsFields = StepsAnnotatedField.findOptionalAnnotatedFields(testCase.getClass());
        StepAnnotations.instanciateScenarioStepFields(testCase, stepFactory, stepsFields);
    }

    public static void injectNestedScenarioStepsInto(Object scenarioSteps, StepFactory stepFactory, Class<?> scenarioStepsClass) {
        List<StepsAnnotatedField> stepsFields = StepsAnnotatedField.findOptionalAnnotatedFields(scenarioStepsClass);
        StepAnnotations.instanciateScenarioStepFields(scenarioSteps, stepFactory, stepsFields);
    }

    private static void instanciateScenarioStepFields(Object testCaseOrSteps, StepFactory stepFactory, List<StepsAnnotatedField> stepsFields) {
        for (StepsAnnotatedField stepsField : stepsFields) {
            StepAnnotations.instantiateAnyUnitiaializedSteps(testCaseOrSteps, stepFactory, stepsField);
        }
    }

    private static void instantiateAnyUnitiaializedSteps(Object testCaseOrSteps, StepFactory stepFactory, StepsAnnotatedField stepsField) {
        if (!stepsField.isInstantiated(testCaseOrSteps)) {
            Class<? extends ScenarioSteps> scenarioStepsClass = stepsField.getFieldClass();
            ScenarioSteps steps = stepFactory.getStepLibraryFor(scenarioStepsClass);
            stepsField.setValue(testCaseOrSteps, steps);
            StepAnnotations.injectNestedScenarioStepsInto(steps, stepFactory, scenarioStepsClass);
        }
    }

    public static void injectAnnotatedPagesObjectInto(Object testCase, Pages pages) {
        PagesAnnotatedField pagesField = PagesAnnotatedField.findFirstAnnotatedField(testCase.getClass());
        if (pagesField != null) {
            pages.setDefaultBaseUrl(pagesField.getDefaultBaseUrl());
            pagesField.setValue(testCase, pages);
        }
    }
}

