/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.google.inject.Inject;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.WebdriverInstances;
import net.thucydides.core.webdriver.WebdriverManager;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThucydidesWebdriverManager
implements WebdriverManager {
    private static final ThreadLocal<WebdriverInstances> webdriverInstancesThreadLocal = new ThreadLocal();
    private final WebDriverFactory webDriverFactory;
    private final Configuration configuration;
    private static final Logger LOGGER = LoggerFactory.getLogger(ThucydidesWebdriverManager.class);

    @Inject
    public ThucydidesWebdriverManager(WebDriverFactory webDriverFactory, Configuration configuration) {
        this.webDriverFactory = webDriverFactory;
        this.configuration = configuration;
    }

    private static WebDriver newDriver(Configuration configuration, WebDriverFactory webDriverFactory, String driver) {
        SupportedWebDriver supportedDriverType = ThucydidesWebdriverManager.getConfiguredWebDriverWithOverride(configuration, driver);
        Class<? extends WebDriver> webDriverType = WebDriverFactory.getClassFor(supportedDriverType);
        return WebdriverProxyFactory.getFactory().proxyFor(webDriverType, webDriverFactory);
    }

    private static SupportedWebDriver getConfiguredWebDriverWithOverride(Configuration configuration, String driver) {
        if (StringUtils.isEmpty((CharSequence)driver)) {
            return configuration.getDriverType();
        }
        return SupportedWebDriver.getDriverTypeFor(driver);
    }

    public void closeDriver() {
        ThucydidesWebdriverManager.inThisTestThread().closeCurrentDriver();
    }

    public void closeAllDrivers() {
        ThucydidesWebdriverManager.inThisTestThread().closeAllDrivers();
    }

    public WebDriver getWebdriver() {
        return ThucydidesWebdriverManager.getThreadLocalWebDriver(this.configuration, this.webDriverFactory, ThucydidesWebdriverManager.inThisTestThread().getCurrentDriverName());
    }

    public WebDriver getWebdriver(String driver) {
        return ThucydidesWebdriverManager.getThreadLocalWebDriver(this.configuration, this.webDriverFactory, driver);
    }

    private static WebDriver getThreadLocalWebDriver(Configuration configuration, WebDriverFactory webDriverFactory, String driver) {
        if (!ThucydidesWebdriverManager.inThisTestThread().driverIsRegisteredFor(driver)) {
            ThucydidesWebdriverManager.inThisTestThread().registerDriverCalled(driver).forDriver(ThucydidesWebdriverManager.newDriver(configuration, webDriverFactory, driver));
        }
        return ThucydidesWebdriverManager.inThisTestThread().useDriver(driver);
    }

    private static WebdriverInstances inThisTestThread() {
        if (webdriverInstancesThreadLocal.get() == null) {
            webdriverInstancesThreadLocal.set(new WebdriverInstances());
        }
        return webdriverInstancesThreadLocal.get();
    }
}

