/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.reflect.Field;
import java.util.NoSuchElementException;
import net.thucydides.core.annotations.AnnotatedFields;
import net.thucydides.core.annotations.InvalidManagedWebDriverFieldException;
import net.thucydides.core.annotations.Managed;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedWebDriverAnnotatedField {
    private static final String NO_ANNOTATED_FIELD_ERROR = "No WebDriver field annotated with @Managed was found in the test case.";
    private final Field field;

    public static ManagedWebDriverAnnotatedField findFirstAnnotatedField(Class<?> testClass) {
        try {
            Field annotatedField = (Field)Iterables.find(ManagedWebDriverAnnotatedField.fieldsIn(testClass), ManagedWebDriverAnnotatedField.withCorrectAnnotations());
            return new ManagedWebDriverAnnotatedField(annotatedField);
        }
        catch (NoSuchElementException e) {
            throw new InvalidManagedWebDriverFieldException(NO_ANNOTATED_FIELD_ERROR);
        }
    }

    public static boolean hasManagedWebdriverField(Class<?> testClass) {
        try {
            Iterables.find(ManagedWebDriverAnnotatedField.fieldsIn(testClass), ManagedWebDriverAnnotatedField.withCorrectAnnotations());
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    private static Predicate<Field> withCorrectAnnotations() {
        return new Predicate<Field>(){

            public boolean apply(Field field) {
                return ManagedWebDriverAnnotatedField.isFieldAnnotated(field);
            }
        };
    }

    private static boolean isFieldAnnotated(Field field) {
        return ManagedWebDriverAnnotatedField.fieldIsAnnotatedCorrectly(field) && ManagedWebDriverAnnotatedField.fieldIsRightType(field);
    }

    private static boolean fieldIsRightType(Field field) {
        return field.getType().isAssignableFrom(WebDriver.class);
    }

    private static boolean fieldIsAnnotatedCorrectly(Field field) {
        return field.getAnnotation(Managed.class) != null;
    }

    protected ManagedWebDriverAnnotatedField(Field field) {
        this.field = field;
    }

    public void setValue(Object testCase, WebDriver manageDriver) {
        try {
            this.field.setAccessible(true);
            this.field.set(testCase, manageDriver);
        }
        catch (IllegalAccessException e) {
            throw new InvalidManagedWebDriverFieldException("Could not access or set web driver field: " + this.field + " - is this field public?", e);
        }
    }

    private static ImmutableSet<Field> fieldsIn(Class clazz) {
        return ImmutableSet.copyOf(AnnotatedFields.of(clazz).allFields());
    }

    public boolean isUniqueSession() {
        return this.field.getAnnotation(Managed.class).uniqueSession();
    }

    public String getDriver() {
        return this.field.getAnnotation(Managed.class).driver();
    }
}

