/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.google.common.base.Joiner;
import net.thucydides.core.webdriver.UnsupportedDriverException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SupportedWebDriver {
    FIREFOX(FirefoxDriver.class),
    CHROME(ChromeDriver.class),
    HTMLUNIT(HtmlUnitDriver.class),
    IEXPLORER(InternetExplorerDriver.class);

    private final Class<? extends WebDriver> webdriverClass;

    private SupportedWebDriver(Class<? extends WebDriver> webdriverClass) {
        this.webdriverClass = webdriverClass;
    }

    public Class<? extends WebDriver> getWebdriverClass() {
        return this.webdriverClass;
    }

    public static String listOfSupportedDrivers() {
        return Joiner.on((String)", ").join((Object[])SupportedWebDriver.values());
    }

    public static SupportedWebDriver getDriverTypeFor(String value) throws UnsupportedDriverException {
        try {
            return SupportedWebDriver.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedDriverException("Unsupported browser type: " + value, e);
        }
    }
}

