/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.matchers;

import ch.lambdaj.Lambda;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.thucydides.core.matchers.InstantiatedPropertyMatcher;
import org.apache.commons.beanutils.BeanUtils;
import org.hamcrest.Matcher;

public class PropertyMatcher {
    private final String fieldName;
    private final Matcher<String> matcher;

    protected PropertyMatcher(String fieldName, Matcher<String> matcher) {
        this.fieldName = fieldName;
        this.matcher = matcher;
    }

    public boolean matches(Object bean) {
        String fieldValue = null;
        try {
            fieldValue = BeanUtils.getProperty((Object)bean, (String)this.fieldName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not find property value for " + this.fieldName);
        }
        return this.matcher.matches((Object)fieldValue);
    }

    public Matcher<Object> getMatcher() {
        return new InstantiatedPropertyMatcher(this);
    }

    public String toString() {
        String htmlFriendlyMatcherDescription = this.matcher.toString().replaceAll("\"", "'");
        return this.fieldName + " " + htmlFriendlyMatcherDescription;
    }

    public static PropertyMatcher the(String fieldName, Matcher<String> matcher) {
        return new PropertyMatcher(fieldName, matcher);
    }

    public static void shouldMatch(List<? extends Object> items, PropertyMatcher ... matchers) {
        Object filteredItems = ImmutableList.copyOf(items);
        for (PropertyMatcher matcher : matchers) {
            filteredItems = Lambda.filter(matcher.getMatcher(), (Iterable)filteredItems);
            if (filteredItems.isEmpty()) {
                throw new AssertionError((Object)("Failed to find matching entries for " + matcher));
            }
        }
    }

    public static boolean matches(List<? extends Object> items, PropertyMatcher ... matchers) {
        try {
            PropertyMatcher.shouldMatch(items, matchers);
            return true;
        }
        catch (AssertionError e) {
            return false;
        }
    }
}

