/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.matchers;

import ch.lambdaj.Lambda;
import com.google.common.collect.ImmutableList;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.thucydides.core.matchers.InstantiatedPropertyMatcher;
import org.apache.commons.beanutils.PropertyUtils;
import org.hamcrest.Matcher;

public class PropertyMatcher {
    private final String fieldName;
    private final Matcher<? extends Object> matcher;

    protected PropertyMatcher(String fieldName, Matcher<? extends Object> matcher) {
        this.fieldName = fieldName;
        this.matcher = matcher;
    }

    public <T> boolean matches(T bean) {
        Object fieldValue;
        try {
            fieldValue = PropertyUtils.getProperty(bean, (String)this.fieldName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not find property value for " + this.fieldName);
        }
        return this.matcher.matches(fieldValue);
    }

    public <T> Matcher<T> getMatcher() {
        return new InstantiatedPropertyMatcher(this);
    }

    public String toString() {
        String matcherDescription = this.matcher.toString();
        String htmlFriendlyMatcherDescription = matcherDescription != null ? matcherDescription.replaceAll("\"", "'") : "";
        return this.fieldName + " " + htmlFriendlyMatcherDescription;
    }

    public static PropertyMatcher the(String fieldName, Matcher<? extends Object> matcher) {
        return new PropertyMatcher(fieldName, matcher);
    }

    public static <T> boolean matches(List<T> elements, PropertyMatcher ... matchers) {
        return !PropertyMatcher.filterElements(elements, matchers).isEmpty();
    }

    public static <T> void shouldMatch(List<T> items, PropertyMatcher ... matchers) {
        if (!PropertyMatcher.matches(items, matchers)) {
            throw new AssertionError((Object)("Failed to find matching entries for " + Arrays.toString(matchers)));
        }
    }

    public static <T> void shouldMatch(T bean, PropertyMatcher ... matchers) {
        if (!PropertyMatcher.matches(bean, matchers)) {
            throw new AssertionError((Object)("Expected " + Arrays.toString(matchers) + " but was " + PropertyMatcher.descriptionOf(bean)));
        }
    }

    private static String descriptionOf(Object bean) {
        if (PropertyMatcher.isAMap(bean)) {
            return PropertyMatcher.mapDescription((Map)bean);
        }
        return PropertyMatcher.beanDescription(bean);
    }

    private static String beanDescription(Object bean) {
        ArrayList<String> propertyTerms = new ArrayList<String>();
        try {
            for (PropertyDescriptor descriptor : PropertyMatcher.propertiesOf(bean)) {
                Method getter = descriptor.getReadMethod();
                if (getter == null) continue;
                propertyTerms.add(PropertyMatcher.propertyValueOf(descriptor.getDisplayName(), getter.invoke(bean, new Object[0]).toString()));
            }
            return Lambda.join(propertyTerms);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Could not read bean properties", e);
        }
    }

    private static String mapDescription(Map<String, ? extends Object> map) {
        ArrayList<String> propertyTerms = new ArrayList<String>();
        for (String key : map.keySet()) {
            propertyTerms.add(PropertyMatcher.propertyValueOf(key, map.get(key).toString()));
        }
        return Lambda.join(propertyTerms);
    }

    private static String propertyValueOf(String propertyName, String value) {
        return propertyName + " = '" + value + "'";
    }

    private static boolean isAMap(Object bean) {
        return Map.class.isAssignableFrom(bean.getClass());
    }

    private static <T> PropertyDescriptor[] propertiesOf(T bean) throws IntrospectionException {
        return Introspector.getBeanInfo(bean.getClass(), Object.class).getPropertyDescriptors();
    }

    public static <T> boolean matches(T bean, PropertyMatcher ... matchers) {
        return PropertyMatcher.matches(Arrays.asList(bean), matchers);
    }

    public static <T> List<T> filterElements(List<T> elements, PropertyMatcher ... matchers) {
        Object filteredItems = ImmutableList.copyOf(elements);
        for (PropertyMatcher matcher : matchers) {
            filteredItems = Lambda.filter(matcher.getMatcher(), (Iterable)filteredItems);
        }
        return filteredItems;
    }
}

