/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.ScenarioSteps;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.steps.StepInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepFactory {
    private final Pages pages;
    private final Map<Class<?>, Object> index = new HashMap();
    private static final Logger LOGGER = LoggerFactory.getLogger(StepFactory.class);
    private static final Class<?>[] CONSTRUCTOR_ARG_TYPES = new Class[]{Pages.class};

    public StepFactory(Pages pages) {
        this.pages = pages;
    }

    public StepFactory() {
        this.pages = null;
    }

    public <T> T getStepLibraryFor(Class<T> scenarioStepsClass) {
        if (this.isStepLibraryInstantiatedFor(scenarioStepsClass)) {
            return this.getManagedStepLibraryFor(scenarioStepsClass);
        }
        return this.instantiateNewStepLibraryFor(scenarioStepsClass);
    }

    public <T> T getNewStepLibraryFor(Class<T> scenarioStepsClass) {
        if (this.isStepLibraryInstantiatedFor(scenarioStepsClass)) {
            return this.getManagedStepLibraryFor(scenarioStepsClass);
        }
        return this.instantiateNewStepLibraryFor(scenarioStepsClass);
    }

    public <T> T getUniqueStepLibraryFor(Class<T> scenarioStepsClass) {
        return this.instantiateUniqueStepLibraryFor(scenarioStepsClass);
    }

    private boolean isStepLibraryInstantiatedFor(Class<?> scenarioStepsClass) {
        return this.index.containsKey(scenarioStepsClass);
    }

    private <T> T getManagedStepLibraryFor(Class<T> scenarioStepsClass) {
        return (T)this.index.get(scenarioStepsClass);
    }

    private <T> T instantiateNewStepLibraryFor(Class<T> scenarioStepsClass) {
        T steps = this.createProxyStepLibrary(scenarioStepsClass);
        this.indexStepLibrary(scenarioStepsClass, steps);
        this.instantiateAnyNestedStepLibrariesIn(steps, scenarioStepsClass);
        return steps;
    }

    private <T> T instantiateUniqueStepLibraryFor(Class<T> scenarioStepsClass) {
        T steps = this.createProxyStepLibrary(scenarioStepsClass);
        this.instantiateAnyNestedStepLibrariesIn(steps, scenarioStepsClass);
        return steps;
    }

    private <T> T createProxyStepLibrary(Class<T> scenarioStepsClass) {
        Enhancer e = new Enhancer();
        e.setSuperclass(scenarioStepsClass);
        StepInterceptor stepInterceptor = new StepInterceptor(scenarioStepsClass);
        e.setCallback((Callback)stepInterceptor);
        if (this.isWebdriverStepClass(scenarioStepsClass)) {
            return this.webEnabledStepLibrary(scenarioStepsClass, e);
        }
        return (T)e.create();
    }

    private <T> T webEnabledStepLibrary(Class<T> scenarioStepsClass, Enhancer e) {
        if (this.hasAPagesConstructor(scenarioStepsClass)) {
            Object[] arguments = new Object[]{this.pages};
            return (T)e.create((Class[])CONSTRUCTOR_ARG_TYPES, arguments);
        }
        Object newStepLibrary = e.create();
        return (T)this.injectPagesInto(scenarioStepsClass, newStepLibrary);
    }

    private <T> T injectPagesInto(Class<T> stepLibraryClass, T newStepLibrary) {
        if (this.hasAPagesField(stepLibraryClass)) {
            ImmutableSet fields = ImmutableSet.copyOf((Object[])stepLibraryClass.getDeclaredFields());
            Field pagesField = (Field)Iterables.find((Iterable)fields, this.ofTypePages());
            pagesField.setAccessible(true);
            try {
                pagesField.set(newStepLibrary, this.pages);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Could not instantiate pages field for step library {}", newStepLibrary);
            }
        }
        return newStepLibrary;
    }

    private <T> boolean isWebdriverStepClass(Class<T> stepLibraryClass) {
        return this.isAScenarioStepClass(stepLibraryClass) || this.hasAPagesConstructor(stepLibraryClass) || this.hasAPagesField(stepLibraryClass);
    }

    private <T> boolean hasAPagesConstructor(Class<T> stepLibraryClass) {
        ImmutableSet constructors = ImmutableSet.copyOf((Object[])stepLibraryClass.getDeclaredConstructors());
        return Iterables.any((Iterable)constructors, this.withASinglePagesParameter());
    }

    private <T> boolean hasAPagesField(Class<T> stepLibraryClass) {
        ImmutableSet fields = ImmutableSet.copyOf((Object[])stepLibraryClass.getDeclaredFields());
        return Iterables.any((Iterable)fields, this.ofTypePages());
    }

    private Predicate<Constructor> withASinglePagesParameter() {
        return new Predicate<Constructor>(){

            public boolean apply(Constructor constructor) {
                return constructor.getParameterTypes().length == 1 && constructor.getParameterTypes()[0] == Pages.class;
            }
        };
    }

    private Predicate<Field> ofTypePages() {
        return new Predicate<Field>(){

            public boolean apply(Field field) {
                return field.getType() == Pages.class;
            }
        };
    }

    private <T> boolean isAScenarioStepClass(Class<T> stepLibraryClass) {
        return ScenarioSteps.class.isAssignableFrom(stepLibraryClass);
    }

    private <T> void indexStepLibrary(Class<T> scenarioStepsClass, T steps) {
        this.index.put(scenarioStepsClass, steps);
    }

    private <T> void instantiateAnyNestedStepLibrariesIn(T steps, Class<T> scenarioStepsClass) {
        StepAnnotations.injectNestedScenarioStepsInto(steps, this, scenarioStepsClass);
    }
}

