/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages.components;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.thucydides.core.matchers.PropertyMatcher;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class HtmlTable {
    private final WebElement tableElement;

    public HtmlTable(WebElement tableElement) {
        this.tableElement = tableElement;
    }

    public List<Map<String, String>> getRows() {
        ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>();
        List<String> headings = this.getHeadings();
        List<WebElement> rows = this.getRowElements();
        for (WebElement row : rows) {
            results.add(this.rowDataFrom(row, headings));
        }
        return results;
    }

    public List<String> getHeadings() {
        return Lambda.convert(this.getHeadingElements(), this.toTextValues());
    }

    public List<WebElement> getHeadingElements() {
        return this.tableElement.findElements(By.tagName((String)"th"));
    }

    public List<WebElement> getRowElements() {
        return this.tableElement.findElements(By.xpath((String)".//tr[td]"));
    }

    public List<WebElement> getRowElementsMatching(PropertyMatcher ... matchers) {
        List<WebElement> rowElements = this.getRowElements();
        List<Integer> matchingRowIndexes = this.findMatchingIndexesFor(rowElements, matchers);
        ArrayList<WebElement> matchingElements = new ArrayList<WebElement>();
        for (Integer index : matchingRowIndexes) {
            matchingElements.add(rowElements.get(index));
        }
        return matchingElements;
    }

    private List<Integer> findMatchingIndexesFor(List<WebElement> rowElements, PropertyMatcher[] matchers) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        List<String> headings = this.getHeadings();
        int index = 0;
        for (WebElement rowElement : rowElements) {
            Map<String, String> rowData = this.rowDataFrom(rowElement, headings);
            if (this.matches(rowData, matchers)) {
                indexes.add(index);
            }
            ++index;
        }
        return indexes;
    }

    private boolean matches(Map<String, String> rowData, PropertyMatcher[] matchers) {
        for (PropertyMatcher matcher : matchers) {
            if (matcher.matches(rowData)) continue;
            return false;
        }
        return true;
    }

    private Map<String, String> rowDataFrom(WebElement row, List<String> headings) {
        HashMap<String, String> rowData = new HashMap<String, String>();
        List cells = row.findElements(By.tagName((String)"td"));
        int column = 0;
        for (String heading : headings) {
            String cell;
            if ((cell = this.cellValueAt(column++, cells)) == null) continue;
            rowData.put(heading, cell);
        }
        return rowData;
    }

    private String cellValueAt(int column, List<WebElement> cells) {
        if (column < cells.size()) {
            return cells.get(column).getText();
        }
        return null;
    }

    private Converter<WebElement, String> toTextValues() {
        return new Converter<WebElement, String>(){

            public String convert(WebElement from) {
                return from.getText();
            }
        };
    }

    public static List<Map<String, String>> rowsFrom(WebElement table) {
        return new HtmlTable(table).getRows();
    }

    public static List<WebElement> filterRows(WebElement table, PropertyMatcher ... matchers) {
        return new HtmlTable(table).getRowElementsMatching(matchers);
    }
}

