/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.matchers;

import java.util.Collection;
import java.util.HashSet;
import net.thucydides.core.matchers.BeanCollectionMatcher;
import net.thucydides.core.matchers.BeanMatchers;

public class BeanUniquenessMatcher
implements BeanCollectionMatcher {
    private final String fieldName;

    public BeanUniquenessMatcher(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public <T> boolean matches(Collection<T> elements) {
        HashSet<Object> fieldValues = new HashSet<Object>();
        for (T bean : elements) {
            fieldValues.add(BeanMatchers.getFieldValue(bean, this.fieldName));
        }
        return fieldValues.size() == elements.size();
    }

    public String toString() {
        return "each " + this.fieldName + " is different";
    }
}

