/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.matchers;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.thucydides.core.matchers.BeanCollectionMatcher;
import net.thucydides.core.matchers.BeanMatchers;
import org.hamcrest.Matcher;

public class MinFieldValueMatcher
implements BeanCollectionMatcher {
    private final String fieldName;
    private final Matcher<? extends Comparable> valueMatcher;

    public MinFieldValueMatcher(String fieldName, Matcher<? extends Comparable> valueMatcher) {
        this.fieldName = fieldName;
        this.valueMatcher = valueMatcher;
    }

    @Override
    public <T> boolean matches(Collection<T> elements) {
        List fieldValues = Lambda.convert(elements, this.toComparable());
        return this.valueMatcher.matches(Collections.min(fieldValues));
    }

    private <T> Converter<T, Comparable> toComparable() {
        return new Converter<T, Comparable>(){

            public Comparable convert(T bean) {
                return (Comparable)BeanMatchers.getFieldValue(bean, MinFieldValueMatcher.this.fieldName);
            }
        };
    }

    public String toString() {
        return "the minimum " + this.fieldName + " " + this.valueMatcher.toString();
    }
}

