/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.thucydides.core.ThucydidesSystemProperties;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.FeatureResults;
import net.thucydides.core.model.NumericalFormatter;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.StoryTestResults;
import net.thucydides.core.model.UserStoriesResultSet;
import net.thucydides.core.model.features.FeatureLoader;
import net.thucydides.core.model.userstories.UserStoryLoader;
import net.thucydides.core.reports.ThucydidesReportData;
import net.thucydides.core.reports.UserStoryTestReporter;
import net.thucydides.core.reports.history.TestHistory;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.reports.html.HtmlReporter;
import net.thucydides.core.reports.html.history.TestResultSnapshot;
import net.thucydides.core.reports.json.JSONProgressResultTree;
import net.thucydides.core.reports.json.JSONResultTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlAggregateStoryReporter
extends HtmlReporter
implements UserStoryTestReporter {
    private static final String DEFAULT_USER_STORY_TEMPLATE = "freemarker/user-story.ftl";
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlAggregateStoryReporter.class);
    private static final String STORIES_TEMPLATE_PATH = "freemarker/stories.ftl";
    private static final String HISTORY_TEMPLATE_PATH = "freemarker/history.ftl";
    private static final String FEATURES_TEMPLATE_PATH = "freemarker/features.ftl";
    private static final String COVERAGE_DATA_TEMPLATE_PATH = "freemarker/coverage.ftl";
    private static final String PROGRESS_DATA_TEMPLATE_PATH = "freemarker/progress.ftl";
    private static final String HOME_TEMPLATE_PATH = "freemarker/index.ftl";
    private static final String DASHBOARD_TEMPLATE_PATH = "freemarker/dashboard.ftl";
    private FeatureLoader featureLoader;
    private UserStoryLoader storyLoader = new UserStoryLoader();
    private TestHistory testHistory;
    private String projectName;
    private final IssueTracking issueTracking;

    public HtmlAggregateStoryReporter(String projectName) {
        this(projectName, (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class));
    }

    public HtmlAggregateStoryReporter(String projectName, IssueTracking issueTracking) {
        this.featureLoader = new FeatureLoader();
        this.projectName = projectName;
        this.issueTracking = issueTracking;
    }

    public String getProjectName() {
        return this.projectName;
    }

    protected TestHistory getTestHistory() {
        if (this.testHistory == null) {
            this.testHistory = new TestHistory(this.getProjectName());
        }
        return this.testHistory;
    }

    @Override
    public File generateReportFor(StoryTestResults storyTestResults) throws IOException {
        LOGGER.info("Generating report for user story {} to {}", (Object)storyTestResults.getTitle(), (Object)this.getOutputDirectory());
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("story", storyTestResults);
        this.addFormattersToContext(context);
        String htmlContents = this.mergeTemplate(DEFAULT_USER_STORY_TEMPLATE).usingContext(context);
        this.copyResourcesToOutputDirectory();
        String reportFilename = storyTestResults.getReportName(ReportNamer.ReportType.HTML);
        return this.writeReportToOutputDirectory(reportFilename, htmlContents);
    }

    private void addFormattersToContext(Map<String, Object> context) {
        Formatter formatter = new Formatter(this.issueTracking);
        context.put("formatter", formatter);
        context.put("formatted", new NumericalFormatter());
    }

    @Override
    public ThucydidesReportData generateReportsForStoriesFrom(File sourceDirectory) throws IOException {
        List<StoryTestResults> storyResults = this.loadStoryResultsFrom(sourceDirectory);
        List<FeatureResults> featureResults = this.loadFeatureResultsFrom(sourceDirectory);
        this.copyResourcesToOutputDirectory();
        for (StoryTestResults storyTestResults : storyResults) {
            this.generateReportFor(storyTestResults);
        }
        this.generateAggregateReportFor(storyResults, featureResults);
        return new ThucydidesReportData(featureResults, storyResults);
    }

    private List<StoryTestResults> loadStoryResultsFrom(File sourceDirectory) throws IOException {
        return this.storyLoader.loadFrom(sourceDirectory);
    }

    private List<FeatureResults> loadFeatureResultsFrom(File sourceDirectory) throws IOException {
        return this.featureLoader.loadFrom(sourceDirectory);
    }

    private void generateAggregateReportFor(List<StoryTestResults> storyResults, List<FeatureResults> featureResults) throws IOException {
        LOGGER.info("Generating summary report for user stories to " + this.getOutputDirectory());
        this.copyResourcesToOutputDirectory();
        this.generateStoriesReport(storyResults);
        this.generateFeatureReport(featureResults);
        this.generateReportHomePage(storyResults, featureResults);
        this.updateHistoryFor(featureResults);
        this.generateHistoryReport();
    }

    private void updateHistoryFor(List<FeatureResults> featureResults) {
        this.getTestHistory().updateData(featureResults);
    }

    private void generateHistoryReport() throws IOException {
        List<TestResultSnapshot> history = this.getTestHistory().getHistory();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("history", history);
        context.put("rowcount", history.size());
        this.addFormattersToContext(context);
        String htmlContents = this.mergeTemplate(HISTORY_TEMPLATE_PATH).usingContext(context);
        LOGGER.debug("Writing history page");
        this.writeReportToOutputDirectory("history.html", htmlContents);
    }

    private void generateFeatureReport(List<FeatureResults> featureResults) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        this.addFormattersToContext(context);
        context.put("features", featureResults);
        String htmlContents = this.mergeTemplate(FEATURES_TEMPLATE_PATH).usingContext(context);
        this.writeReportToOutputDirectory("features.html", htmlContents);
        for (FeatureResults feature : featureResults) {
            this.generateStoryReportForFeature(feature);
        }
    }

    private void generateStoryReportForFeature(FeatureResults feature) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("stories", feature.getStoryResults());
        context.put("storyContext", feature.getFeature().getName());
        this.addFormattersToContext(context);
        LOGGER.debug("Generating stories page");
        String htmlContents = this.mergeTemplate(STORIES_TEMPLATE_PATH).usingContext(context);
        LOGGER.debug("Writing stories page");
        String filename = feature.getStoryReportName();
        this.writeReportToOutputDirectory(filename, htmlContents);
    }

    private void generateStoriesReport(List<StoryTestResults> storyResults) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("stories", storyResults);
        context.put("storyContext", "All stories");
        this.addFormattersToContext(context);
        String htmlContents = this.mergeTemplate(STORIES_TEMPLATE_PATH).usingContext(context);
        LOGGER.debug("Writing stories page");
        this.writeReportToOutputDirectory("stories.html", htmlContents);
    }

    private void generateReportHomePage(List<StoryTestResults> storyResults, List<FeatureResults> featureResults) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("stories", new UserStoriesResultSet(storyResults));
        context.put("features", featureResults);
        this.addFormattersToContext(context);
        LOGGER.debug("Generating report pages");
        this.generateReportPage(context, HOME_TEMPLATE_PATH, "index.html");
        this.generateReportPage(context, DASHBOARD_TEMPLATE_PATH, "dashboard.html");
        LOGGER.debug("Generating coverage data");
        this.generateCoverageData(featureResults);
        this.generateProgressData(featureResults);
    }

    private void generateReportPage(Map<String, Object> context, String template, String outputFile) throws IOException {
        String htmlContents = this.mergeTemplate(template).usingContext(context);
        this.writeReportToOutputDirectory(outputFile, htmlContents);
    }

    private void generateCoverageData(List<FeatureResults> featureResults) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        JSONResultTree resultTree = new JSONResultTree();
        for (FeatureResults feature : featureResults) {
            resultTree.addFeature(feature);
        }
        context.put("coverageData", resultTree.toJSON());
        this.addFormattersToContext(context);
        String javascriptCoverageData = this.mergeTemplate(COVERAGE_DATA_TEMPLATE_PATH).usingContext(context);
        this.writeReportToOutputDirectory("coverage.js", javascriptCoverageData);
    }

    private void generateProgressData(List<FeatureResults> featureResults) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        JSONProgressResultTree resultTree = new JSONProgressResultTree();
        for (FeatureResults feature : featureResults) {
            resultTree.addFeature(feature);
        }
        context.put("progressData", resultTree.toJSON());
        this.addFormattersToContext(context);
        String javascriptCoverageData = this.mergeTemplate(PROGRESS_DATA_TEMPLATE_PATH).usingContext(context);
        this.writeReportToOutputDirectory("progress.js", javascriptCoverageData);
    }

    public void clearHistory() {
        this.getTestHistory().clearHistory();
    }

    protected ThucydidesSystemProperties getSystemProperties() {
        return ThucydidesSystemProperties.getProperties();
    }

    public void setIssueTrackerUrl(String issueTrackerUrl) {
        if (issueTrackerUrl != null) {
            this.getSystemProperties().setValue(ThucydidesSystemProperty.ISSUE_TRACKER_URL, issueTrackerUrl);
        }
    }

    public void setJiraUrl(String jiraUrl) {
        if (jiraUrl != null) {
            this.getSystemProperties().setValue(ThucydidesSystemProperty.JIRA_URL, jiraUrl);
        }
    }

    public void setJiraProject(String jiraProject) {
        if (jiraProject != null) {
            this.getSystemProperties().setValue(ThucydidesSystemProperty.JIRA_PROJECT, jiraProject);
        }
    }
}

