/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.matchers;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.collect.ImmutableList;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.thucydides.core.matchers.BeanCollectionMatcher;
import net.thucydides.core.matchers.BeanCountMatcher;
import net.thucydides.core.matchers.BeanFieldMatcher;
import net.thucydides.core.matchers.BeanMatcher;
import net.thucydides.core.matchers.BeanPropertyMatcher;
import net.thucydides.core.matchers.BeanUniquenessMatcher;
import net.thucydides.core.matchers.MaxFieldValueMatcher;
import net.thucydides.core.matchers.MinFieldValueMatcher;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.ListUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class BeanMatchers {
    private static final String NEW_LINE = System.getProperty("line.separator");

    public static BeanMatcher the(String fieldName, Matcher<? extends Object> matcher) {
        return new BeanPropertyMatcher(fieldName, matcher);
    }

    public static BeanMatcher the_count(Matcher<Integer> countMatcher) {
        return new BeanCountMatcher(countMatcher);
    }

    public static BeanConstraint each(String fieldName) {
        return new BeanConstraint(fieldName);
    }

    public static BeanMatcher max(String fieldName, Matcher<? extends Comparable> valueMatcher) {
        return new MaxFieldValueMatcher(fieldName, valueMatcher);
    }

    public static BeanMatcher min(String fieldName, Matcher<? extends Comparable> valueMatcher) {
        return new MinFieldValueMatcher(fieldName, valueMatcher);
    }

    protected static Object getFieldValue(Object bean, String fieldName) {
        try {
            return PropertyUtils.getProperty((Object)bean, (String)fieldName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not find property value for " + fieldName);
        }
    }

    public static <T> boolean matches(List<T> elements, BeanMatcher ... matchers) {
        List<T> filteredElements = BeanMatchers.filterElements(elements, matchers);
        return BeanMatchers.apply(filteredElements, BeanMatchers.collectionMatchersIn(matchers));
    }

    private static <T> boolean apply(List<T> elements, List<BeanCollectionMatcher> matchers) {
        List<BeanCollectionMatcher> collectionMatchers = BeanMatchers.addEmptyTestIfNoCountChecksArePresentTo(matchers);
        for (BeanCollectionMatcher matcher : collectionMatchers) {
            if (matcher.matches(elements)) continue;
            return false;
        }
        return true;
    }

    private static List<BeanCollectionMatcher> addEmptyTestIfNoCountChecksArePresentTo(List<BeanCollectionMatcher> matchers) {
        if (Matchers.hasEntry(matchers, (Object)Matchers.instanceOf(BeanCountMatcher.class)).matches(matchers)) {
            return matchers;
        }
        return ListUtils.union(matchers, Arrays.asList(BeanMatchers.the_count((Matcher<Integer>)Matchers.is((Matcher)Matchers.not((Object)0)))));
    }

    private static List<BeanCollectionMatcher> collectionMatchersIn(BeanMatcher[] matchers) {
        List compatibleMatchers = Lambda.filter((Matcher)Matchers.instanceOf(BeanCollectionMatcher.class), (Object[])matchers);
        return Lambda.convert((Object)compatibleMatchers, BeanMatchers.toBeanCollectionMatchers());
    }

    private static Converter<BeanMatcher, BeanCollectionMatcher> toBeanCollectionMatchers() {
        return new Converter<BeanMatcher, BeanCollectionMatcher>(){

            public BeanCollectionMatcher convert(BeanMatcher from) {
                return (BeanCollectionMatcher)from;
            }
        };
    }

    public static <T> List<T> filterElements(List<T> elements, BeanMatcher ... matchers) {
        Object filteredItems = ImmutableList.copyOf(elements);
        for (BeanFieldMatcher matcher : BeanMatchers.propertyMatchersIn(matchers)) {
            filteredItems = Lambda.filter(matcher.getMatcher(), (Iterable)filteredItems);
        }
        return filteredItems;
    }

    private static List<BeanFieldMatcher> propertyMatchersIn(BeanMatcher[] matchers) {
        List compatibleMatchers = Lambda.filter((Matcher)Matchers.instanceOf(BeanFieldMatcher.class), (Object[])matchers);
        return Lambda.convert((Object)compatibleMatchers, BeanMatchers.toBeanFieldMatchers());
    }

    private static Converter<BeanMatcher, BeanFieldMatcher> toBeanFieldMatchers() {
        return new Converter<BeanMatcher, BeanFieldMatcher>(){

            public BeanFieldMatcher convert(BeanMatcher from) {
                return (BeanFieldMatcher)from;
            }
        };
    }

    public static <T> void shouldMatch(List<T> items, BeanMatcher ... matchers) {
        if (!BeanMatchers.matches(items, matchers)) {
            throw new AssertionError((Object)("Failed to find matching elements for " + Arrays.toString(matchers) + NEW_LINE + "Elements where " + items));
        }
    }

    public static <T> void shouldMatch(T bean, BeanMatcher ... matchers) {
        if (!BeanMatchers.matches(bean, matchers)) {
            throw new AssertionError((Object)("Expected " + Arrays.toString(matchers) + " but was " + BeanMatchers.descriptionOf(bean)));
        }
    }

    private static String descriptionOf(Object bean) {
        if (BeanMatchers.isAMap(bean)) {
            return BeanMatchers.mapDescription((Map)bean);
        }
        return BeanMatchers.beanDescription(bean);
    }

    private static String beanDescription(Object bean) {
        ArrayList<String> propertyTerms = new ArrayList<String>();
        try {
            for (PropertyDescriptor descriptor : BeanMatchers.propertiesOf(bean)) {
                Method getter = descriptor.getReadMethod();
                if (getter == null) continue;
                propertyTerms.add(BeanMatchers.propertyValueOf(descriptor.getDisplayName(), getter.invoke(bean, new Object[0]).toString()));
            }
            return Lambda.join(propertyTerms);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Could not read bean properties", e);
        }
    }

    private static String mapDescription(Map<String, ? extends Object> map) {
        ArrayList<String> propertyTerms = new ArrayList<String>();
        for (String key : map.keySet()) {
            propertyTerms.add(BeanMatchers.propertyValueOf(key, map.get(key).toString()));
        }
        return Lambda.join(propertyTerms);
    }

    private static boolean isAMap(Object bean) {
        return Map.class.isAssignableFrom(bean.getClass());
    }

    public static <T> boolean matches(T bean, BeanMatcher ... matchers) {
        return BeanMatchers.matches(Arrays.asList(bean), matchers);
    }

    private static String propertyValueOf(String propertyName, String value) {
        return propertyName + " = '" + value + "'";
    }

    private static <T> PropertyDescriptor[] propertiesOf(T bean) throws IntrospectionException {
        return Introspector.getBeanInfo(bean.getClass(), Object.class).getPropertyDescriptors();
    }

    public static class BeanConstraint {
        private final String fieldName;

        public BeanConstraint(String fieldName) {
            this.fieldName = fieldName;
        }

        public BeanMatcher isDifferent() {
            return new BeanUniquenessMatcher(this.fieldName);
        }
    }
}

