/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.matchers;

import net.thucydides.core.matchers.BeanFieldMatcher;
import net.thucydides.core.matchers.BeanMatchers;
import net.thucydides.core.matchers.InstantiatedBeanMatcher;
import org.hamcrest.Matcher;

public class BeanPropertyMatcher
implements BeanFieldMatcher {
    private final String fieldName;
    private final Matcher<? extends Object> matcher;

    protected BeanPropertyMatcher(String fieldName, Matcher<? extends Object> matcher) {
        this.fieldName = fieldName;
        this.matcher = matcher;
    }

    @Override
    public boolean matches(Object bean) {
        return this.matcher.matches(BeanMatchers.getFieldValue(bean, this.fieldName));
    }

    @Override
    public <T> Matcher<T> getMatcher() {
        return new InstantiatedBeanMatcher(this);
    }

    public String toString() {
        String matcherDescription = this.matcher.toString();
        String htmlFriendlyMatcherDescription = matcherDescription != null ? matcherDescription.replaceAll("\"", "'") : "";
        return this.fieldName + " " + htmlFriendlyMatcherDescription;
    }
}

