/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.features.ApplicationFeature;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.lang3.StringUtils;

public class ReportNamer {
    private ReportType type;

    public ReportNamer(ReportType type) {
        this.type = type;
    }

    public String getNormalizedTestNameFor(TestOutcome testOutcome) {
        String testName = "";
        if (testOutcome.getUserStory() != null) {
            testName = NameConverter.underscore(testOutcome.getUserStory().getName());
        }
        String scenarioName = NameConverter.underscore(testOutcome.getMethodName());
        testName = NameConverter.withNoIssueNumbers(NameConverter.withNoArguments(this.appendToIfNotNull(testName, scenarioName)));
        return this.appendSuffixTo(testName);
    }

    private String appendToIfNotNull(String baseString, String nextElement) {
        if (StringUtils.isNotEmpty((CharSequence)baseString)) {
            return baseString + "_" + nextElement;
        }
        return nextElement;
    }

    public String getNormalizedTestNameFor(TestOutcome testOutcome, String qualifier) {
        String userStory = "";
        if (testOutcome.getUserStory() != null) {
            userStory = NameConverter.underscore(testOutcome.getUserStory().getName()) + "_";
        }
        String normalizedQualifier = qualifier.replaceAll(" ", "_");
        return this.appendSuffixTo(userStory + NameConverter.withNoArguments(testOutcome.getMethodName()) + "_" + normalizedQualifier);
    }

    public String getNormalizedTestNameFor(Story userStory) {
        String testNameWithUnderscores = NameConverter.underscore(userStory.getName());
        return this.appendSuffixTo(testNameWithUnderscores);
    }

    public String getNormalizedTestNameFor(ApplicationFeature feature) {
        String testNameWithUnderscores = NameConverter.underscore(feature.getName());
        return this.appendSuffixTo(testNameWithUnderscores);
    }

    private String appendSuffixTo(String testNameWithUnderscores) {
        if (this.type == ReportType.ROOT) {
            return testNameWithUnderscores;
        }
        return testNameWithUnderscores + "." + this.type.toString();
    }

    public static enum ReportType {
        ROOT(""),
        XML("xml"),
        HTML("html");

        private String suffix;

        private ReportType(String suffix) {
            this.suffix = suffix;
        }

        public String toString() {
            return this.suffix;
        }
    }
}

