/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ThucydidesSystemProperty {
    DRIVER("webdriver.driver"),
    BASE_URL("webdriver.base.url"),
    REPORT_RESOURCE_PATH("thucydides.report.resources"),
    OUTPUT_DIRECTORY("thucydides.outputDirectory"),
    ONLY_SAVE_FAILING_SCREENSHOTS("thucydides.only.save.failing.screenshots"),
    RESTART_BROWSER_FREQUENCY("thucydides.restart.browser.frequency"),
    STEP_DELAY("thucycides.step.delay"),
    ELEMENT_TIMEOUT("thucydides.timeout"),
    ASSUME_UNTRUSTED_CERTIFICATE_ISSUER("refuse.untrusted.certificates"),
    UNIQUE_BROWSER("thucydides.use.unique.browser"),
    ESTIMATED_AVERAGE_STEP_COUNT("thucydides.estimated.average.step.count"),
    ISSUE_TRACKER_URL("thucydides.issue.tracker.url"),
    JIRA_URL("jira.url"),
    HISTORY_BASE_DIRECTORY("thucydides.history"),
    SNAPSHOT_HEIGHT("thucydides.browser.height"),
    SNAPSHOT_WIDTH("thucydides.browser.width"),
    PUBLIC_URL("thucydides.public.url");

    private String propertyName;

    private ThucydidesSystemProperty(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public static boolean getBooleanValue(ThucydidesSystemProperty property, boolean defaultValue) {
        String value = System.getProperty(property.getPropertyName());
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return defaultValue;
    }

    public static String getValue(ThucydidesSystemProperty property, String defaultValue) {
        return System.getProperty(property.getPropertyName(), defaultValue);
    }

    public static Integer getIntegerValue(ThucydidesSystemProperty property, Integer defaultValue) {
        String value = System.getProperty(property.getPropertyName());
        if (value != null) {
            return Integer.valueOf(value);
        }
        return defaultValue;
    }

    public static String getValue(ThucydidesSystemProperty property) {
        return System.getProperty(property.getPropertyName());
    }

    public static void setValue(ThucydidesSystemProperty issueTrackerUrl, String value) {
        System.setProperty(issueTrackerUrl.getPropertyName(), value);
    }

    public static String getIssueTrackerUrl() {
        if (ThucydidesSystemProperty.getValue(JIRA_URL) != null) {
            return ThucydidesSystemProperty.getValue(JIRA_URL) + "/browse/{0}";
        }
        return ThucydidesSystemProperty.getValue(ISSUE_TRACKER_URL);
    }

    public String toString() {
        return this.propertyName;
    }
}

