/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.images.ResizableImage;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.Screenshot;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.reports.html.HtmlReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlAcceptanceTestReporter
extends HtmlReporter
implements AcceptanceTestReporter {
    private static final String DEFAULT_ACCEPTANCE_TEST_REPORT = "freemarker/default.ftl";
    private static final String DEFAULT_ACCEPTANCE_TEST_SCREENSHOT = "freemarker/screenshots.ftl";
    private static final int MAXIMUM_SCREENSHOT_WIDTH = 1000;
    private String qualifier;

    @Override
    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    @Override
    public String getName() {
        return "html";
    }

    @Override
    public File generateReportFor(TestOutcome testOutcome) throws IOException {
        Preconditions.checkNotNull((Object)this.getOutputDirectory());
        HashMap<String, Object> context = new HashMap<String, Object>();
        this.addTestOutcomeToContext(testOutcome, context);
        this.addFormattersToContext(context);
        String htmlContents = this.mergeTemplate(DEFAULT_ACCEPTANCE_TEST_REPORT).usingContext(context);
        this.copyResourcesToOutputDirectory();
        this.generateScreenshotReportsFor(testOutcome);
        String reportFilename = this.reportFor(testOutcome);
        return this.writeReportToOutputDirectory(reportFilename, htmlContents);
    }

    private void addTestOutcomeToContext(TestOutcome testOutcome, Map<String, Object> context) {
        context.put("testOutcome", testOutcome);
    }

    private void addFormattersToContext(Map<String, Object> context) {
        Formatter formatter = new Formatter(ThucydidesSystemProperty.getIssueTrackerUrl());
        context.put("formatter", formatter);
    }

    private void generateScreenshotReportsFor(TestOutcome testOutcome) throws IOException {
        Preconditions.checkNotNull((Object)this.getOutputDirectory());
        List<Screenshot> screenshots = this.expandScreenshots(testOutcome.getScreenshots());
        String screenshotReport = this.withoutType(testOutcome.getReportName() + "_screenshots") + ".html";
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("screenshots", screenshots);
        context.put("testOutcome", testOutcome);
        String htmlContents = this.mergeTemplate(DEFAULT_ACCEPTANCE_TEST_SCREENSHOT).usingContext(context);
        this.writeReportToOutputDirectory(screenshotReport, htmlContents);
    }

    private List<Screenshot> expandScreenshots(List<Screenshot> screenshots) throws IOException {
        ArrayList<Screenshot> expandScreenshotList = new ArrayList<Screenshot>();
        int maxWidth = this.maxScreenshotWidthIn(screenshots);
        int maxHeight = this.maxScreenshotHeightIn(screenshots);
        for (Screenshot screenshot : screenshots) {
            File screenshotFile = new File(this.getOutputDirectory(), screenshot.getFilename());
            if (screenshotFile.exists()) {
                ResizableImage scaledImage = ResizableImage.loadFrom(screenshotFile).rescaleCanvas(maxWidth, maxHeight);
                File scaledFile = new File(this.getOutputDirectory(), "scaled_" + screenshot.getFilename());
                scaledImage.saveTo(scaledFile);
                expandScreenshotList.add(new Screenshot(scaledFile.getName(), screenshot.getDescription()));
                continue;
            }
            expandScreenshotList.add(screenshot);
        }
        return expandScreenshotList;
    }

    private int maxScreenshotWidthIn(List<Screenshot> screenshots) throws IOException {
        int maxWidth = 0;
        for (Screenshot screenshot : screenshots) {
            File screenshotFile = new File(this.getOutputDirectory(), screenshot.getFilename());
            if (!screenshotFile.exists()) continue;
            maxWidth = this.maxWidthOf(maxWidth, screenshotFile);
        }
        return maxWidth;
    }

    private int maxWidthOf(int maxWidth, File screenshotFile) throws IOException {
        int width = ResizableImage.loadFrom(screenshotFile).getWitdh();
        if (width > 1000) {
            width = 1000;
        }
        if (width > maxWidth) {
            maxWidth = width;
        }
        return maxWidth;
    }

    private int maxScreenshotHeightIn(List<Screenshot> screenshots) throws IOException {
        int maxHeight = 0;
        for (Screenshot screenshot : screenshots) {
            File screenshotFile = new File(this.getOutputDirectory(), screenshot.getFilename());
            if (!screenshotFile.exists()) continue;
            maxHeight = this.maxHeightOf(maxHeight, screenshotFile);
        }
        return maxHeight;
    }

    private int maxHeightOf(int maxHeight, File screenshotFile) throws IOException {
        int height = ResizableImage.loadFrom(screenshotFile).getHeight();
        int width = ResizableImage.loadFrom(screenshotFile).getWitdh();
        if (width > 1000) {
            height = (int)((double)height * 1.0 * (1000.0 / (double)width));
        }
        if (height > maxHeight) {
            maxHeight = height;
        }
        return maxHeight;
    }

    private String withoutType(String screenshot) {
        int dot = screenshot.lastIndexOf(46);
        if (dot > 0) {
            return screenshot.substring(0, dot);
        }
        return screenshot;
    }

    private String reportFor(TestOutcome testOutcome) {
        if (this.qualifier != null) {
            return testOutcome.getReportName(ReportNamer.ReportType.HTML, this.qualifier);
        }
        return testOutcome.getReportName(ReportNamer.ReportType.HTML);
    }
}

