/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.ScenarioSteps;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.steps.StepInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepFactory {
    private final Pages pages;
    private final List<ScenarioSteps> managedSteps = new ArrayList<ScenarioSteps>();
    private final Map<Class<? extends ScenarioSteps>, ScenarioSteps> index = new HashMap<Class<? extends ScenarioSteps>, ScenarioSteps>();
    private static final Class<?>[] CONSTRUCTOR_ARG_TYPES = new Class[]{Pages.class};

    public StepFactory(Pages pages) {
        this.pages = pages;
    }

    public <T extends ScenarioSteps> T getStepLibraryFor(Class<T> scenarioStepsClass) {
        if (this.isStepLibraryInstantiatedFor(scenarioStepsClass)) {
            return this.getManagedStepLibraryFor(scenarioStepsClass);
        }
        return this.instantiateNewStepLibraryFor(scenarioStepsClass);
    }

    public <T extends ScenarioSteps> T getUniqueStepLibraryFor(Class<T> scenarioStepsClass) {
        return this.instantiateUniqueStepLibraryFor(scenarioStepsClass);
    }

    private boolean isStepLibraryInstantiatedFor(Class<? extends ScenarioSteps> scenarioStepsClass) {
        return this.index.containsKey(scenarioStepsClass);
    }

    private <T extends ScenarioSteps> T getManagedStepLibraryFor(Class<T> scenarioStepsClass) {
        return (T)this.index.get(scenarioStepsClass);
    }

    private <T extends ScenarioSteps> T instantiateNewStepLibraryFor(Class<T> scenarioStepsClass) {
        T steps = this.createProxyStepLibrary(scenarioStepsClass);
        this.recordManagedStepLibrary(steps);
        this.indexStepLibrary(scenarioStepsClass, steps);
        this.instantiateAnyNestedStepLibrariesIn((ScenarioSteps)steps, (Class<? extends ScenarioSteps>)scenarioStepsClass);
        return steps;
    }

    private <T extends ScenarioSteps> T instantiateUniqueStepLibraryFor(Class<T> scenarioStepsClass) {
        T steps = this.createProxyStepLibrary(scenarioStepsClass);
        this.recordManagedStepLibrary(steps);
        this.instantiateAnyNestedStepLibrariesIn((ScenarioSteps)steps, (Class<? extends ScenarioSteps>)scenarioStepsClass);
        return steps;
    }

    private <T extends ScenarioSteps> T createProxyStepLibrary(Class<T> scenarioStepsClass) {
        Enhancer e = new Enhancer();
        e.setSuperclass(scenarioStepsClass);
        StepInterceptor stepInterceptor = new StepInterceptor(scenarioStepsClass);
        e.setCallback((Callback)stepInterceptor);
        Object[] arguments = new Object[]{this.pages};
        return (T)((ScenarioSteps)e.create((Class[])CONSTRUCTOR_ARG_TYPES, arguments));
    }

    private <T extends ScenarioSteps> void recordManagedStepLibrary(T steps) {
        this.managedSteps.add(steps);
    }

    private <T extends ScenarioSteps> void indexStepLibrary(Class<T> scenarioStepsClass, T steps) {
        this.index.put(scenarioStepsClass, steps);
    }

    private void instantiateAnyNestedStepLibrariesIn(ScenarioSteps steps, Class<? extends ScenarioSteps> scenarioStepsClass) {
        StepAnnotations.injectNestedScenarioStepsInto(steps, this, scenarioStepsClass);
    }

    public void notifyStepFinished() {
        for (ScenarioSteps step : this.managedSteps) {
            step.done();
        }
    }
}

