/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages;

import java.util.concurrent.TimeUnit;
import net.thucydides.core.pages.JavaScriptExecutorFacade;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Clock;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.Sleeper;
import org.openqa.selenium.support.ui.SystemClock;
import org.openqa.selenium.support.ui.Wait;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebElementFacade {
    private final WebElement webElement;
    private final WebDriver driver;
    private final long timeoutInMilliseconds;
    private static final int WAIT_FOR_ELEMENT_PAUSE_LENGTH = 250;
    private final Sleeper sleeper;
    private final Clock webdriverClock;
    private JavaScriptExecutorFacade javaScriptExecutorFacade;

    public WebElementFacade(WebDriver driver, WebElement webElement, long timeoutInMilliseconds) {
        this.driver = driver;
        this.webElement = webElement;
        this.timeoutInMilliseconds = timeoutInMilliseconds;
        this.webdriverClock = new SystemClock();
        this.sleeper = Sleeper.SYSTEM_SLEEPER;
        this.javaScriptExecutorFacade = new JavaScriptExecutorFacade(driver);
    }

    protected JavaScriptExecutorFacade getJavaScriptExecutorFacade() {
        return this.javaScriptExecutorFacade;
    }

    public boolean isVisible() {
        try {
            return this.webElement.isDisplayed();
        }
        catch (NoSuchElementException e) {
            return false;
        }
        catch (StaleElementReferenceException se) {
            return false;
        }
    }

    public boolean isCurrentlyVisible() {
        return this.isVisible();
    }

    public boolean isCurrentlyEnabled() {
        try {
            return this.webElement.isEnabled();
        }
        catch (NoSuchElementException e) {
            return false;
        }
        catch (StaleElementReferenceException se) {
            return false;
        }
    }

    public void shouldBeVisible() {
        if (!this.isVisible()) {
            throw new AssertionError((Object)"Element should be visible");
        }
    }

    public void shouldBeCurrentlyVisible() {
        if (!this.isCurrentlyVisible()) {
            throw new AssertionError((Object)"Element should be visible");
        }
    }

    public void shouldNotBeVisible() {
        if (this.isVisible()) {
            throw new AssertionError((Object)"Element should not be visible");
        }
    }

    public void shouldNotBeCurrentlyVisible() {
        if (this.isCurrentlyVisible()) {
            throw new AssertionError((Object)"Element should not be visible");
        }
    }

    public boolean hasFocus() {
        JavaScriptExecutorFacade js = new JavaScriptExecutorFacade(this.driver);
        WebElement activeElement = (WebElement)js.executeScript("return window.document.activeElement");
        return this.webElement.equals(activeElement);
    }

    public boolean containsText(String value) {
        return this.webElement.getText().contains(value);
    }

    public void shouldContainText(String textValue) {
        if (!this.containsText(textValue)) {
            String errorMessage = String.format("The text '%s' was not found in the web element", textValue);
            throw new AssertionError((Object)errorMessage);
        }
    }

    public void shouldNotContainText(String textValue) {
        if (this.containsText(textValue)) {
            String errorMessage = String.format("The text '%s' was not found in the web element", textValue);
            throw new AssertionError((Object)errorMessage);
        }
    }

    public void shouldBeEnabled() {
        if (!this.isEnabled()) {
            String errorMessage = String.format("Field '%s' should be enabled", this.webElement);
            throw new AssertionError((Object)errorMessage);
        }
    }

    public boolean isEnabled() {
        return this.webElement.isEnabled();
    }

    public void shouldNotBeEnabled() {
        if (this.isEnabled()) {
            String errorMessage = String.format("Field '%s' should not be enabled", this.webElement);
            throw new AssertionError((Object)errorMessage);
        }
    }

    public void type(String value) {
        this.waitUntilElementAvailable();
        this.webElement.clear();
        this.webElement.sendKeys(new CharSequence[]{value});
    }

    public void typeAndEnter(String value) {
        this.waitUntilElementAvailable();
        this.webElement.clear();
        this.webElement.sendKeys(new CharSequence[]{value, Keys.ENTER});
    }

    public void typeAndTab(String value) {
        this.waitUntilElementAvailable();
        this.webElement.clear();
        this.webElement.sendKeys(new CharSequence[]{value + Keys.TAB});
    }

    public void setWindowFocus() {
        this.getJavaScriptExecutorFacade().executeScript("window.focus()");
    }

    public void selectByVisibleText(String label) {
        this.waitUntilElementAvailable();
        Select select = new Select(this.webElement);
        select.selectByVisibleText(label);
    }

    public String getSelectedVisibleTextValue() {
        this.waitUntilElementAvailable();
        Select select = new Select(this.webElement);
        return select.getFirstSelectedOption().getText();
    }

    public void selectByValue(String value) {
        this.waitUntilElementAvailable();
        Select select = new Select(this.webElement);
        select.selectByValue(value);
    }

    public String getSelectedValue() {
        this.waitUntilElementAvailable();
        Select select = new Select(this.webElement);
        return select.getFirstSelectedOption().getAttribute("value");
    }

    public void selectByIndex(int indexValue) {
        this.waitUntilElementAvailable();
        Select select = new Select(this.webElement);
        select.selectByIndex(indexValue);
    }

    private void waitUntilElementAvailable() {
        this.waitUntilVisible();
        this.waitUntilEnabled();
    }

    public boolean isPresent() {
        try {
            return this.webElement.isDisplayed() || !this.webElement.isDisplayed();
        }
        catch (NoSuchElementException e) {
            return e.getCause().getMessage().contains("Element is not usable");
        }
    }

    public void shouldBePresent() {
        if (!this.isPresent()) {
            String errorMessage = String.format("Field should be present", new Object[0]);
            throw new AssertionError((Object)errorMessage);
        }
    }

    public void shouldNotBePresent() {
        if (this.isPresent()) {
            String errorMessage = String.format("Field should not be present", new Object[0]);
            throw new AssertionError((Object)errorMessage);
        }
    }

    public void waitUntilVisible() {
        try {
            this.waitForElement().until(this.elementIsDisplayed());
        }
        catch (TimeoutException timeout) {
            this.throwErrorWithCauseIfPresent(timeout, timeout.getMessage());
        }
    }

    private void throwErrorWithCauseIfPresent(TimeoutException timeout, String defaultMessage) {
        String timeoutMessage = timeout.getCause() != null ? timeout.getCause().getMessage() : timeout.getMessage();
        throw new ElementNotVisibleException(timeoutMessage, (Throwable)timeout);
    }

    private ExpectedCondition<Boolean> elementIsDisplayed() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return WebElementFacade.this.webElement.isDisplayed();
            }
        };
    }

    private ExpectedCondition<Boolean> elementIsNotDisplayed() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return !WebElementFacade.this.isCurrentlyVisible();
            }
        };
    }

    private ExpectedCondition<Boolean> elementIsEnabled() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return WebElementFacade.this.webElement.isEnabled();
            }
        };
    }

    private ExpectedCondition<Boolean> elementIsNotEnabled() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return !WebElementFacade.this.webElement.isEnabled();
            }
        };
    }

    private Wait<WebDriver> waitForElement() {
        return new FluentWait((Object)this.driver, this.webdriverClock, this.sleeper).withTimeout(this.timeoutInMilliseconds, TimeUnit.MILLISECONDS).pollingEvery(250L, TimeUnit.MILLISECONDS).ignoring(new Class[]{NoSuchElementException.class, NoSuchFrameException.class});
    }

    public void waitUntilNotVisible() {
        try {
            this.waitForElement().until(this.elementIsNotDisplayed());
        }
        catch (TimeoutException timeout) {
            this.throwErrorWithCauseIfPresent(timeout, "Expected hidden element was displayed");
        }
    }

    public String getValue() {
        this.waitUntilElementAvailable();
        return this.webElement.getAttribute("value");
    }

    public String getText() {
        this.waitUntilElementAvailable();
        return this.webElement.getText();
    }

    public void waitUntilEnabled() {
        try {
            this.waitForElement().until(this.elementIsEnabled());
        }
        catch (TimeoutException timeout) {
            throw new ElementNotVisibleException("Expected enabled element was not enabled", (Throwable)timeout);
        }
    }

    public void waitUntilDisabled() {
        try {
            this.waitForElement().until(this.elementIsNotEnabled());
        }
        catch (TimeoutException timeout) {
            throw new ElementNotVisibleException("Expected disabled element was not enabled", (Throwable)timeout);
        }
    }

    public String getTextValue() {
        this.waitUntilElementAvailable();
        if (!this.getText().isEmpty()) {
            return this.webElement.getText();
        }
        if (!this.getValue().isEmpty()) {
            return this.getValue();
        }
        return "";
    }

    public void click() {
        this.waitUntilElementAvailable();
        this.webElement.click();
    }
}

