/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import com.google.common.collect.ImmutableList;
import com.google.inject.internal.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import net.thucydides.core.model.Story;
import net.thucydides.core.steps.DataDrivenStep;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.steps.TestStepResult;
import sun.misc.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepEventBus {
    private static ThreadLocal<StepEventBus> stepEventBusThreadLocal = new ThreadLocal();
    private static final String CORE_THUCYDIDES_PACKAGE = "net.thucydides.core";
    private List<StepListener> registeredListeners = new ArrayList<StepListener>();
    private TestStepResult resultTally;
    private Stack<String> stepStack = new Stack();
    private Stack<Boolean> webdriverSuspensions = new Stack();
    private Set<StepListener> customListeners;
    private boolean stepFailed;
    private boolean pendingTest;
    private Class<?> classUnderTest;
    private Story storyUnderTest;

    public static StepEventBus getEventBus() {
        if (stepEventBusThreadLocal.get() == null) {
            stepEventBusThreadLocal.set(new StepEventBus());
        }
        return stepEventBusThreadLocal.get();
    }

    public StepEventBus registerListener(StepListener listener) {
        this.registeredListeners.add(listener);
        return this;
    }

    public void testStarted(String testName) {
        this.clear();
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.testStarted(testName);
        }
    }

    protected List<StepListener> getAllListeners() {
        ArrayList allListeners = Lists.newArrayList(this.registeredListeners);
        allListeners.addAll(this.getCustomListeners());
        return ImmutableList.copyOf((Collection)allListeners);
    }

    private Set<StepListener> getCustomListeners() {
        if (this.customListeners == null) {
            this.customListeners = Collections.synchronizedSet(new HashSet());
            Iterator listenerImplementations = Service.providers(StepListener.class);
            while (listenerImplementations.hasNext()) {
                StepListener listener = (StepListener)listenerImplementations.next();
                if (this.isACore(listener)) continue;
                this.customListeners.add(listener);
            }
        }
        return this.customListeners;
    }

    private boolean isACore(StepListener listener) {
        return listener.getClass().getPackage().getName().startsWith(CORE_THUCYDIDES_PACKAGE);
    }

    public void testSuiteStarted(Class<?> testClass) {
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.testSuiteStarted(testClass);
        }
        this.updateClassUnderTest(testClass);
    }

    private void updateClassUnderTest(Class<?> testClass) {
        this.classUnderTest = testClass;
    }

    public void testSuiteStarted(Story story) {
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.testSuiteStarted(story);
        }
    }

    public void clear() {
        this.stepStack.clear();
        this.clearStepFailures();
        this.currentTestIsNotPending();
        this.resultTally = null;
        this.classUnderTest = null;
        this.webdriverSuspensions.clear();
    }

    private void currentTestIsNotPending() {
        this.pendingTest = false;
    }

    private TestStepResult getResultTally() {
        if (this.resultTally == null) {
            this.resultTally = TestStepResult.forTestClass(this.classUnderTest);
        }
        return this.resultTally;
    }

    public void testFinished() {
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.testFinished(this.getResultTally());
        }
        this.clear();
    }

    private void pushStep(String stepName) {
        this.stepStack.push(stepName);
    }

    private void popStep() {
        this.stepStack.pop();
    }

    private void clearStepFailures() {
        this.stepFailed = false;
    }

    public boolean aStepInTheCurrentTestHasFailed() {
        return this.stepFailed;
    }

    public boolean isCurrentTestDataDriven() {
        return DataDrivenStep.inProgress();
    }

    public void stepStarted(ExecutedStepDescription executedStepDescription) {
        this.pushStep(executedStepDescription.getName());
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.stepStarted(executedStepDescription);
        }
    }

    public void stepFinished() {
        this.stepDone();
        this.getResultTally().logExecutedTest();
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.stepFinished();
        }
    }

    private void stepDone() {
        this.popStep();
    }

    public void stepFailed(StepFailure failure) {
        this.stepDone();
        this.getResultTally().logFailure(failure);
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.stepFailed(failure);
        }
        this.stepFailed = true;
    }

    public void stepIgnored() {
        this.stepDone();
        this.getResultTally().logIgnoredTest();
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.stepIgnored();
        }
    }

    public void stepPending() {
        this.stepDone();
        this.getResultTally().logIgnoredTest();
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.stepPending();
        }
    }

    public void dropListener(StepListener stepListener) {
        this.registeredListeners.remove(stepListener);
    }

    public void dropAllListeners() {
        this.registeredListeners.clear();
    }

    public boolean webdriverCallsAreSuspended() {
        return this.aStepInTheCurrentTestHasFailed() || !this.webdriverSuspensions.isEmpty();
    }

    public void reenableWebdriverCalls() {
        this.webdriverSuspensions.pop();
    }

    public void temporarilySuspendWebdriverCalls() {
        this.webdriverSuspensions.push(true);
    }

    public void testFailed(Throwable cause) {
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.testFailed(cause);
        }
    }

    public void testPending() {
        this.pendingTest = true;
    }

    public boolean currentTestIsPending() {
        return this.pendingTest;
    }

    public void testIgnored() {
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.testIgnored();
        }
    }

    public boolean areStepsRunning() {
        return !this.stepStack.isEmpty();
    }
}

