/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages.components;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.thucydides.core.matchers.BeanMatcher;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class HtmlTable {
    private final WebElement tableElement;

    public HtmlTable(WebElement tableElement) {
        this.tableElement = tableElement;
    }

    public List<Map<Object, String>> getRows() {
        ArrayList<Map<Object, String>> results = new ArrayList<Map<Object, String>>();
        List<String> headings = this.getHeadings();
        List<WebElement> rows = this.getRowElements();
        for (WebElement row : rows) {
            List<WebElement> cells = this.cellsIn(row);
            if (!this.enoughCellsFor(headings).in(cells)) continue;
            results.add(this.rowDataFrom(cells, headings));
        }
        return results;
    }

    private EnoughCellsCheck enoughCellsFor(List<String> headings) {
        return new EnoughCellsCheck(headings);
    }

    public List<String> getHeadings() {
        return Lambda.convert(this.getHeadingElements(), this.toTextValues());
    }

    public List<WebElement> getHeadingElements() {
        return this.tableElement.findElements(By.tagName((String)"th"));
    }

    public List<WebElement> getRowElements() {
        return this.tableElement.findElements(By.xpath((String)".//tr[td]"));
    }

    public List<WebElement> getRowElementsMatching(BeanMatcher ... matchers) {
        List<WebElement> rowElements = this.getRowElements();
        List<Integer> matchingRowIndexes = this.findMatchingIndexesFor(rowElements, matchers);
        ArrayList<WebElement> matchingElements = new ArrayList<WebElement>();
        for (Integer index : matchingRowIndexes) {
            matchingElements.add(rowElements.get(index));
        }
        return matchingElements;
    }

    private List<Integer> findMatchingIndexesFor(List<WebElement> rowElements, BeanMatcher[] matchers) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        List<String> headings = this.getHeadings();
        int index = 0;
        for (WebElement row : rowElements) {
            List<WebElement> cells = this.cellsIn(row);
            Map<Object, String> rowData = this.rowDataFrom(cells, headings);
            if (this.matches(rowData, matchers)) {
                indexes.add(index);
            }
            ++index;
        }
        return indexes;
    }

    private boolean matches(Map<Object, String> rowData, BeanMatcher[] matchers) {
        for (BeanMatcher matcher : matchers) {
            if (matcher.matches(rowData)) continue;
            return false;
        }
        return true;
    }

    private Map<Object, String> rowDataFrom(List<WebElement> cells, List<String> headings) {
        HashMap<Object, String> rowData = new HashMap<Object, String>();
        int column = 0;
        for (String heading : headings) {
            String cell = this.cellValueAt(column++, cells);
            if (!StringUtils.isEmpty((CharSequence)heading)) {
                rowData.put(heading, cell);
            }
            rowData.put(column, cell);
        }
        return rowData;
    }

    private List<WebElement> cellsIn(WebElement row) {
        return row.findElements(By.tagName((String)"td"));
    }

    private String cellValueAt(int column, List<WebElement> cells) {
        return cells.get(column).getText();
    }

    private Converter<WebElement, String> toTextValues() {
        return new Converter<WebElement, String>(){

            public String convert(WebElement from) {
                return from.getText();
            }
        };
    }

    public static List<Map<Object, String>> rowsFrom(WebElement table) {
        return new HtmlTable(table).getRows();
    }

    public static List<WebElement> filterRows(WebElement table, BeanMatcher ... matchers) {
        return new HtmlTable(table).getRowElementsMatching(matchers);
    }

    private class EnoughCellsCheck {
        private final int minimumNumberOfCells;

        private EnoughCellsCheck(List<String> headings) {
            this.minimumNumberOfCells = headings.size();
        }

        public boolean in(List<WebElement> cells) {
            return cells.size() >= this.minimumNumberOfCells;
        }
    }
}

