/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages;

import java.net.URL;
import net.thucydides.core.annotations.DefaultUrl;
import net.thucydides.core.annotations.NamedUrl;
import net.thucydides.core.annotations.NamedUrls;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.webdriver.Configuration;

public class PageUrls {
    private static final String CLASSPATH_URL_PREFIX = "classpath:";
    private static final int CLASSPATH_URL_PREFIX_LENGTH = "classpath:".length();
    private Object pageObject;
    private String pageLevelDefaultBaseUrl;
    private final Configuration configuration;

    public PageUrls(Object pageObject, Configuration Configuration2) {
        this.pageObject = pageObject;
        this.configuration = Configuration2;
    }

    public PageUrls(Object pageObject) {
        this(pageObject, (Configuration)Injectors.getInjector().getInstance(Configuration.class));
    }

    public String getStartingUrl() {
        DefaultUrl urlAnnotation = this.pageObject.getClass().getAnnotation(DefaultUrl.class);
        if (urlAnnotation != null) {
            String annotatedBaseUrl = urlAnnotation.value();
            String startingUrl = PageUrls.getUrlFrom(annotatedBaseUrl);
            return this.addDefaultBaseUrlIfRelative(startingUrl);
        }
        return this.getDefaultUrl();
    }

    public String getDeclaredDefaultUrl() {
        String annotatedBaseUrl = null;
        DefaultUrl urlAnnotation = this.pageObject.getClass().getAnnotation(DefaultUrl.class);
        if (urlAnnotation != null) {
            annotatedBaseUrl = urlAnnotation.value();
        }
        return annotatedBaseUrl;
    }

    public static String getUrlFrom(String annotatedBaseUrl) {
        if (annotatedBaseUrl == null) {
            return null;
        }
        String classpathUrl = null;
        if (annotatedBaseUrl.startsWith(CLASSPATH_URL_PREFIX)) {
            URL baseUrl = PageUrls.obtainResourcePathFromClasspath(annotatedBaseUrl);
            classpathUrl = baseUrl.toString();
        }
        if (classpathUrl != null) {
            return classpathUrl;
        }
        return annotatedBaseUrl;
    }

    private static URL obtainResourcePathFromClasspath(String annotatedBaseUrl) {
        String resourcePath = annotatedBaseUrl.substring(CLASSPATH_URL_PREFIX_LENGTH);
        URL baseUrl = Thread.currentThread().getContextClassLoader().getResource(resourcePath);
        if (baseUrl == null) {
            throw new IllegalStateException("No matching web page could be found on the classpath for " + annotatedBaseUrl);
        }
        return baseUrl;
    }

    private String getDefaultUrl() {
        if (this.pageLevelDefaultBaseUrl != null) {
            return this.pageLevelDefaultBaseUrl;
        }
        return this.configuration.getBaseUrl();
    }

    public String getStartingUrl(String ... parameterValues) {
        String startingUrlTemplate = this.getStartingUrl();
        return this.urlWithParametersSubstituted(startingUrlTemplate, parameterValues);
    }

    public String getNamedUrl(String name) {
        NamedUrls urlAnnotation = this.pageObject.getClass().getAnnotation(NamedUrls.class);
        if (urlAnnotation != null) {
            NamedUrl[] namedUrlList;
            for (NamedUrl namedUrl : namedUrlList = urlAnnotation.value()) {
                if (!namedUrl.name().equals(name)) continue;
                return namedUrl.url();
            }
        }
        throw new IllegalArgumentException("No URL named " + name + " was found in this class");
    }

    public String getNamedUrl(String name, String[] parameterValues) {
        String startingUrlTemplate = this.getNamedUrl(name);
        return this.urlWithParametersSubstituted(startingUrlTemplate, parameterValues);
    }

    private String urlWithParametersSubstituted(String template, String[] parameterValues) {
        String url = template;
        for (int i = 0; i < parameterValues.length; ++i) {
            String variable = String.format("{%d}", i + 1);
            url = url.replace(variable, parameterValues[i]);
        }
        return this.addDefaultBaseUrlIfRelative(url);
    }

    private String addDefaultBaseUrlIfRelative(String url) {
        if (this.isARelativeUrl(url)) {
            if (this.getDefaultUrl() != null) {
                return this.getDefaultUrl() + url;
            }
            if (this.getDeclaredDefaultUrl() != null) {
                return this.getDeclaredDefaultUrl() + url;
            }
        }
        return url;
    }

    private boolean isARelativeUrl(String url) {
        return url.startsWith("/");
    }

    public void overrideDefaultBaseUrl(String defaultBaseUrl) {
        this.pageLevelDefaultBaseUrl = defaultBaseUrl;
    }

    public String getBaseUrl() {
        return this.configuration.getBaseUrl();
    }
}

