/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.thucydides.core.annotations.Pending;
import net.thucydides.core.annotations.Step;
import net.thucydides.core.annotations.StepGroup;
import net.thucydides.core.annotations.TestAnnotations;
import net.thucydides.core.steps.ErrorConvertor;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepArgumentWriter;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFailure;
import org.openqa.selenium.WebDriverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepInterceptor
implements MethodInterceptor,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<?> testStepClass;
    private Throwable error = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(StepInterceptor.class);
    private final List<String> OBJECT_METHODS = Arrays.asList("toString", "equals", "hashcode", "clone", "notify", "notifyAll", "wait", "finalize");

    public StepInterceptor(Class<?> testStepClass) {
        this.testStepClass = testStepClass;
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        Object result = this.baseClassMethod(method) ? this.runNormalMethod(obj, method, args, proxy) : this.testStepResult(obj, method, args, proxy);
        return result;
    }

    private boolean baseClassMethod(Method method) {
        return this.OBJECT_METHODS.contains(method.getName());
    }

    private Object testStepResult(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        if (!this.isATestStep(method)) {
            return this.runNormalMethod(obj, method, args, proxy);
        }
        if (this.shouldSkip(method)) {
            this.notifySkippedStepStarted(method, args);
            return this.skipTestStep(obj, method, args, proxy);
        }
        this.notifyStepStarted(method, args);
        return this.runTestStep(obj, method, args, proxy);
    }

    private Object skipTestStep(Object obj, Method method, Object[] args, MethodProxy proxy) throws Exception {
        Object skippedReturnObject = this.runSkippedMethod(obj, method, args, proxy);
        this.notifyStepSkippedFor(method, args);
        return this.appropriateReturnObject(skippedReturnObject, obj, method);
    }

    private Object runSkippedMethod(Object obj, Method method, Object[] args, MethodProxy proxy) {
        LOGGER.info("Running test step " + this.getTestNameFrom(method, args, false));
        Object result = null;
        StepEventBus.getEventBus().temporarilySuspendWebdriverCalls();
        try {
            result = this.invokeMethod(obj, method, args, proxy);
        }
        catch (Throwable anyException) {
            LOGGER.trace("Ignoring exception thrown during a skipped test", anyException);
        }
        StepEventBus.getEventBus().reenableWebdriverCalls();
        return result;
    }

    Object appropriateReturnObject(Object returnedValue, Object obj, Method method) {
        if (returnedValue != null) {
            return returnedValue;
        }
        return this.appropriateReturnObject(obj, method);
    }

    Object appropriateReturnObject(Object obj, Method method) {
        if (method.getReturnType().isAssignableFrom(obj.getClass())) {
            return obj;
        }
        return null;
    }

    private boolean shouldSkip(Method step) {
        return this.aPreviousStepHasFailed() || this.testIsPending() || this.isPending(step) || this.isIgnored(step);
    }

    private boolean testIsPending() {
        return StepEventBus.getEventBus().currentTestIsPending();
    }

    private boolean aPreviousStepHasFailed() {
        boolean aPreviousStepHasFailed = false;
        if (StepEventBus.getEventBus().aStepInTheCurrentTestHasFailed() && !StepEventBus.getEventBus().isCurrentTestDataDriven()) {
            aPreviousStepHasFailed = true;
        }
        return aPreviousStepHasFailed;
    }

    private Object runNormalMethod(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        Object result = null;
        try {
            result = this.invokeMethod(obj, method, args, proxy);
        }
        catch (AssertionError assertionError) {
            this.error = assertionError;
            this.notifyOfTestFailure(method, args, (Throwable)((Object)assertionError));
        }
        catch (WebDriverException webdriverException) {
            this.error = webdriverException;
            this.notifyOfTestFailure(method, args, webdriverException);
        }
        return result;
    }

    private StepGroup getTestGroupAnnotationFor(Method method) {
        return method.getAnnotation(StepGroup.class);
    }

    private Step getTestAnnotationFor(Method method) {
        return method.getAnnotation(Step.class);
    }

    private boolean isATestStep(Method method) {
        return this.getTestAnnotationFor(method) != null || this.getTestGroupAnnotationFor(method) != null;
    }

    private boolean isIgnored(Method method) {
        return TestAnnotations.isIgnored(method);
    }

    private Object runTestStep(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        LOGGER.info("Running test step " + this.getTestNameFrom(method, args, false));
        Object result = null;
        try {
            result = proxy.invokeSuper(obj, args);
            this.notifyStepFinishedFor(method, args);
        }
        catch (AssertionError assertionError) {
            this.error = assertionError;
            LOGGER.debug("Assertion error caught - notifying of failure " + assertionError);
            this.notifyOfStepFailure(method, args, (Throwable)((Object)assertionError));
            return this.appropriateReturnObject(obj, method);
        }
        catch (WebDriverException webdriverException) {
            this.error = webdriverException;
            AssertionError webdriverAssertionError = ErrorConvertor.forError(this.error).convertToAssertion();
            this.notifyOfStepFailure(method, args, (Throwable)((Object)webdriverAssertionError));
        }
        catch (Throwable generalException) {
            this.error = generalException;
            AssertionError assertionError = ErrorConvertor.forError(this.error).convertToAssertion();
            this.notifyOfStepFailure(method, args, (Throwable)((Object)assertionError));
        }
        LOGGER.info("Test step done: " + this.getTestNameFrom(method, args, false));
        return result;
    }

    private Object invokeMethod(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        return proxy.invokeSuper(obj, args);
    }

    private boolean isPending(Method method) {
        return method.getAnnotation(Pending.class) != null;
    }

    private void notifyStepFinishedFor(Method method, Object[] args) {
        StepEventBus.getEventBus().stepFinished();
    }

    private String getTestNameFrom(Method method, Object[] args) {
        return this.getTestNameFrom(method, args, true);
    }

    private String getTestNameFrom(Method method, Object[] args, boolean addMarkup) {
        if (args == null || args.length == 0) {
            return method.getName();
        }
        return this.testNameWithArguments(method, args, addMarkup);
    }

    private String testNameWithArguments(Method method, Object[] args, boolean addMarkup) {
        StringBuilder testName = new StringBuilder(method.getName());
        testName.append(": ");
        if (addMarkup) {
            if (args.length == 1) {
                testName.append("<span class='single-parameter'>");
            } else {
                testName.append("<span class='parameters'>");
            }
        }
        boolean isFirst = true;
        for (Object arg : args) {
            if (!isFirst) {
                testName.append(", ");
            }
            testName.append(StepArgumentWriter.readableFormOf(arg));
            isFirst = false;
        }
        if (addMarkup) {
            testName.append("</span>");
        }
        return testName.toString();
    }

    private void notifyStepSkippedFor(Method method, Object[] args) throws Exception {
        if (this.isPending(method)) {
            StepEventBus.getEventBus().stepPending();
        } else {
            StepEventBus.getEventBus().stepIgnored();
        }
    }

    private void notifyOfStepFailure(Method method, Object[] args, Throwable cause) throws Exception {
        ExecutedStepDescription description = ExecutedStepDescription.of(this.testStepClass, this.getTestNameFrom(method, args));
        StepFailure failure = new StepFailure(description, cause);
        StepEventBus.getEventBus().stepFailed(failure);
    }

    private void notifyOfTestFailure(Method method, Object[] args, Throwable cause) throws Exception {
        StepEventBus.getEventBus().testFailed(cause);
    }

    private void notifyStepStarted(Method method, Object[] args) {
        ExecutedStepDescription description = ExecutedStepDescription.of(this.testStepClass, this.getTestNameFrom(method, args));
        StepEventBus.getEventBus().stepStarted(description);
    }

    private void notifySkippedStepStarted(Method method, Object[] args) {
        ExecutedStepDescription description = ExecutedStepDescription.of(this.testStepClass, this.getTestNameFrom(method, args));
        StepEventBus.getEventBus().skippedStepStarted(description);
    }
}

