/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.matchers.dates;

import java.util.Date;
import net.thucydides.core.matchers.dates.DateIsAfterMatcher;
import net.thucydides.core.matchers.dates.DateIsBeforeMatcher;
import net.thucydides.core.matchers.dates.DateIsBetweenMatcher;
import net.thucydides.core.matchers.dates.DateIsSameAsMatcher;
import net.thucydides.core.matchers.dates.DateTimeIsAfterMatcher;
import net.thucydides.core.matchers.dates.DateTimeIsBeforeMatcher;
import net.thucydides.core.matchers.dates.DateTimeIsBetweenMatcher;
import net.thucydides.core.matchers.dates.DateTimeIsSameAsMatcher;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.joda.time.DateTime;

public class DateMatchers {
    @Factory
    public static Matcher<Date> isSameAs(Date expectedDate) {
        return new DateIsSameAsMatcher(expectedDate);
    }

    @Factory
    public static Matcher<Date> isBefore(Date expectedDate) {
        return new DateIsBeforeMatcher(expectedDate);
    }

    @Factory
    public static Matcher<Date> isAfter(Date expectedDate) {
        return new DateIsAfterMatcher(expectedDate);
    }

    @Factory
    public static Matcher<Date> isBetween(Date startDate, Date endDate) {
        return new DateIsBetweenMatcher(startDate, endDate);
    }

    @Factory
    public static Matcher<DateTime> isSameAs(DateTime expectedDate) {
        return new DateTimeIsSameAsMatcher(expectedDate);
    }

    @Factory
    public static Matcher<DateTime> isBefore(DateTime expectedDate) {
        return new DateTimeIsBeforeMatcher(expectedDate);
    }

    @Factory
    public static Matcher<DateTime> isAfter(DateTime expectedDate) {
        return new DateTimeIsAfterMatcher(expectedDate);
    }

    @Factory
    public static Matcher<DateTime> isBetween(DateTime startDate, DateTime endDate) {
        return new DateTimeIsBetweenMatcher(startDate, endDate);
    }
}

