/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model.userstories;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.StoryTestResults;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.xml.NotAThucydidesReportException;
import net.thucydides.core.reports.xml.XMLTestOutcomeReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserStoryLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserStoryLoader.class);

    public List<StoryTestResults> loadFrom(File reportDirectory) throws IOException {
        ArrayList<StoryTestResults> stories = new ArrayList<StoryTestResults>();
        XMLTestOutcomeReporter testOutcomeReporter = new XMLTestOutcomeReporter();
        File[] reportFiles = this.getAllXMLFilesFrom(reportDirectory);
        if (reportFiles == null) {
            LOGGER.error("Could not find any Thucydides reports");
            return stories;
        }
        for (File reportFile : reportFiles) {
            try {
                TestOutcome testOutcome = testOutcomeReporter.loadReportFrom(reportFile);
                if (testOutcome.getUserStory() == null) continue;
                StoryTestResults storyResults = this.userStoryResultsFor(testOutcome, stories);
                storyResults.recordTestRun(testOutcome);
            }
            catch (NotAThucydidesReportException e) {
                LOGGER.info("Skipping XML file - not a Thucydides report: " + reportFile);
            }
        }
        return stories;
    }

    private StoryTestResults userStoryResultsFor(TestOutcome testOutcome, List<StoryTestResults> storyResults) {
        Story userStory = testOutcome.getUserStory();
        for (StoryTestResults storyResult : storyResults) {
            if (!storyResult.containsResultsFor(userStory)) continue;
            return storyResult;
        }
        StoryTestResults storyTestResults = new StoryTestResults(userStory);
        storyResults.add(storyTestResults);
        return storyTestResults;
    }

    private File[] getAllXMLFilesFrom(File reportsDirectory) {
        return reportsDirectory.listFiles(new XmlFilenameFilter());
    }

    private static final class XmlFilenameFilter
    implements FilenameFilter {
        private XmlFilenameFilter() {
        }

        @Override
        public boolean accept(File file, String filename) {
            return filename.toLowerCase(Locale.getDefault()).endsWith(".xml");
        }
    }
}

